/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.Sequence;
import com.oregondsp.signalProcessing.filter.fir.equiripple.DesignGrid;
import com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleFIRFilter;

abstract class FIRTypeIV
extends EquirippleFIRFilter {
    FIRTypeIV(int numBands, int nHalf) {
        super(numBands, nHalf, 2 * nHalf);
    }

    @Override
    void populateGrid(DesignGrid G) {
        for (int i = 0; i < G.gridSize; ++i) {
            G.H[i] = this.desiredResponse(G.grid[i]) / Math.sin(G.grid[i] * Math.PI / 2.0);
            G.W[i] = this.weight(G.grid[i]) * Math.sin(G.grid[i] * Math.PI / 2.0);
        }
        G.containsZero = false;
        G.containsPi = Math.abs(G.grid[G.gridSize - 1] - 1.0) < 1.0E-6;
    }

    @Override
    float[] interpretCoefficients(float[] coefficients) {
        float[] retval = new float[this.Nc];
        Sequence.circularShift(coefficients, this.N - 1);
        retval[0] = -0.5f * coefficients[0];
        for (int i = 1; i < this.Nc - 1; ++i) {
            retval[i] = 0.5f * (coefficients[i - 1] - coefficients[i]);
        }
        retval[this.Nc - 1] = 0.5f * coefficients[this.Nc - 2];
        return retval;
    }
}

