/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.Sequence;
import com.oregondsp.signalProcessing.filter.fir.equiripple.DesignGrid;
import com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleFIRFilter;

abstract class FIRTypeIII
extends EquirippleFIRFilter {
    FIRTypeIII(int numBands, int nHalf) {
        super(numBands, nHalf, 2 * nHalf + 1);
    }

    @Override
    void populateGrid(DesignGrid G) {
        for (int i = 0; i < G.gridSize; ++i) {
            G.H[i] = this.desiredResponse(G.grid[i]) / Math.sin(G.grid[i] * Math.PI);
            G.W[i] = this.weight(G.grid[i]) * Math.sin(G.grid[i] * Math.PI);
        }
        G.containsZero = false;
        G.containsPi = false;
    }

    @Override
    float[] interpretCoefficients(float[] coefficients) {
        float[] retval = new float[this.Nc];
        Sequence.circularShift(coefficients, this.N - 1);
        retval[0] = -0.5f * coefficients[0];
        retval[1] = -0.5f * coefficients[1];
        for (int i = 2; i < this.Nc - 2; ++i) {
            retval[i] = 0.5f * (coefficients[i - 2] - coefficients[i]);
        }
        retval[this.Nc - 2] = 0.5f * coefficients[this.Nc - 4];
        retval[this.Nc - 1] = 0.5f * coefficients[this.Nc - 3];
        return retval;
    }
}

