/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.Sequence;
import com.oregondsp.signalProcessing.filter.fir.equiripple.DesignGrid;
import com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleFIRFilter;

abstract class FIRTypeII
extends EquirippleFIRFilter {
    FIRTypeII(int numBands, int nHalf) {
        super(numBands, nHalf, 2 * nHalf);
    }

    @Override
    void populateGrid(DesignGrid G) {
        for (int i = 0; i < G.gridSize; ++i) {
            G.H[i] = this.desiredResponse(G.grid[i]) / Math.cos(G.grid[i] * Math.PI / 2.0);
            G.W[i] = this.weight(G.grid[i]) * Math.cos(G.grid[i] * Math.PI / 2.0);
        }
        G.containsZero = Math.abs(G.grid[0]) < 1.0E-6;
        G.containsPi = false;
    }

    @Override
    float[] interpretCoefficients(float[] coefficients) {
        float[] retval = new float[this.Nc];
        Sequence.circularShift(coefficients, this.N - 1);
        retval[0] = 0.5f * coefficients[0];
        for (int i = 1; i < this.Nc - 1; ++i) {
            retval[i] = 0.5f * (coefficients[i] + coefficients[i - 1]);
        }
        retval[this.Nc - 1] = 0.5f * coefficients[this.Nc - 2];
        return retval;
    }
}

