/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.Sequence;
import com.oregondsp.signalProcessing.filter.fir.equiripple.DesignGrid;
import com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleFIRFilter;

abstract class FIRTypeI
extends EquirippleFIRFilter {
    FIRTypeI(int numBands, int nHalf) {
        super(numBands, nHalf + 1, 2 * nHalf + 1);
    }

    @Override
    void populateGrid(DesignGrid G) {
        for (int i = 0; i < G.gridSize; ++i) {
            G.H[i] = this.desiredResponse(G.grid[i]);
            G.W[i] = this.weight(G.grid[i]);
        }
        G.containsZero = true;
        G.containsPi = true;
    }

    @Override
    float[] interpretCoefficients(float[] coefficients) {
        float[] retval = new float[this.Nc];
        Sequence.circularShift(coefficients, this.N - 1);
        System.arraycopy(coefficients, 0, retval, 0, this.Nc);
        return retval;
    }
}

