/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeI;

public class EquirippleLowpass
extends FIRTypeI {
    private double Wp;
    private double Ws;

    public EquirippleLowpass(int N, double OmegaP, double Wp, double OmegaS, double Ws) {
        super(2, N);
        if (OmegaP >= OmegaS) {
            throw new IllegalArgumentException("OmegaP >= OmegaS ");
        }
        if (OmegaP <= 0.0 || OmegaP >= 1.0) {
            throw new IllegalArgumentException("OmegaP: " + OmegaP + " out of bounds (0.0 < OmegaP < 1.0)");
        }
        if (OmegaS <= 0.0 || OmegaS >= 1.0) {
            throw new IllegalArgumentException("OmegaS: " + OmegaS + " out of bounds (0.0 < OmegaS < 1.0)");
        }
        this.bands[0][0] = 0.0;
        this.bands[0][1] = OmegaP;
        this.bands[1][0] = OmegaS;
        this.bands[1][1] = 1.0;
        this.Wp = Wp;
        this.Ws = Ws;
        this.generateCoefficients();
    }

    @Override
    double desiredResponse(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = 1.0;
        }
        return retval;
    }

    @Override
    double weight(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = this.Wp;
        } else if (this.LTE(this.bands[1][0], Omega) && this.LTE(Omega, this.bands[1][1])) {
            retval = this.Ws;
        }
        return retval;
    }

    public static void main(String[] args) {
        EquirippleLowpass fir = new EquirippleLowpass(20, 0.45, 1.0, 0.5, 1.0);
        System.out.println("coeff length: " + fir.coefficients.length);
        for (int i = 0; i < fir.coefficients.length; ++i) {
            System.out.println(fir.coefficients[i] + ",");
        }
    }
}

