/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeI;

public class EquirippleHighpass
extends FIRTypeI {
    private double Wp;
    private double Ws;

    public EquirippleHighpass(int N, double OmegaS, double Ws, double OmegaP, double Wp) {
        super(2, N);
        if (OmegaS >= OmegaP) {
            throw new IllegalArgumentException("OmegaS >= OmegaP ");
        }
        if (OmegaS <= 0.0 || OmegaS >= 1.0) {
            throw new IllegalArgumentException("OmegaS: " + OmegaS + " out of bounds (0.0 < OmegaS < 1.0)");
        }
        if (OmegaP <= 0.0 || OmegaP >= 1.0) {
            throw new IllegalArgumentException("OmegaP: " + OmegaP + " out of bounds (0.0 < OmegaP < 1.0)");
        }
        this.bands[0][0] = 0.0;
        this.bands[0][1] = OmegaS;
        this.bands[1][0] = OmegaP;
        this.bands[1][1] = 1.0;
        this.Ws = Ws;
        this.Wp = Wp;
        this.generateCoefficients();
    }

    @Override
    double desiredResponse(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[1][0], Omega) && this.LTE(Omega, this.bands[1][1])) {
            retval = 1.0;
        }
        return retval;
    }

    @Override
    double weight(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = this.Ws;
        } else if (this.LTE(this.bands[1][0], Omega) && this.LTE(Omega, this.bands[1][1])) {
            retval = this.Wp;
        }
        return retval;
    }
}

