/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeII;

class EquirippleHalfBandPrototype
extends FIRTypeII {
    EquirippleHalfBandPrototype(int N, double OmegaP) {
        super(1, N);
        if (OmegaP <= 0.0 || OmegaP >= 1.0) {
            throw new IllegalArgumentException("OmegaP: " + OmegaP + " out of bounds (0.0 < OmegaP < 1.0)");
        }
        this.bands[0][0] = 0.0;
        this.bands[0][1] = OmegaP;
        this.generateCoefficients();
    }

    @Override
    double desiredResponse(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = 1.0;
        }
        return retval;
    }

    @Override
    double weight(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = 1.0;
        }
        return retval;
    }
}

