/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.fft.RDFT;
import com.oregondsp.signalProcessing.filter.fir.OverlapAdd;
import com.oregondsp.signalProcessing.filter.fir.equiripple.DesignGrid;
import com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleDesigner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

abstract class EquirippleFIRFilter {
    protected static double MACHINETOLERANCE = 1.0E-6;
    protected double[][] bands;
    protected int numBands;
    protected int N;
    protected float[] coefficients;
    protected int Nc;
    protected OverlapAdd implementation;

    EquirippleFIRFilter(int numBands, int N, int Nc) {
        this.numBands = numBands;
        this.bands = new double[numBands][2];
        this.N = N;
        this.Nc = Nc;
    }

    protected DesignGrid createGrid() {
        DesignGrid G = new DesignGrid();
        int[] nextrema = new int[this.numBands];
        double totalBandwidth = 0.0;
        for (int ib = 0; ib < this.numBands; ++ib) {
            totalBandwidth += this.bands[ib][1] - this.bands[ib][0];
        }
        int m = this.N + 1 - 2 * this.numBands;
        int np = 0;
        int largestBand = 0;
        int nmax = 0;
        for (int ib = 0; ib < this.numBands; ++ib) {
            double B = this.bands[ib][1] - this.bands[ib][0];
            nextrema[ib] = (int)Math.round((double)m * B / totalBandwidth) + 2;
            if (nextrema[ib] > nmax) {
                nmax = nextrema[ib];
                largestBand = ib;
            }
            np += nextrema[ib];
        }
        while (np < this.N + 1) {
            int n = largestBand;
            nextrema[n] = nextrema[n] + 1;
            ++np;
        }
        while (np > this.N + 1) {
            int n = largestBand;
            nextrema[n] = nextrema[n] - 1;
            --np;
        }
        G.bandEdgeIndices = new int[this.numBands * 2];
        G.extremaIndices = new int[this.N + 1];
        ArrayList<Double> gridArray = new ArrayList<Double>();
        int gridpt = 0;
        int extremum = 0;
        int bandEdgeCount = 0;
        int perturbation = 0;
        Random R = new Random();
        for (int ib = 0; ib < this.numBands; ++ib) {
            double B = this.bands[ib][1] - this.bands[ib][0];
            int n = 1 + (nextrema[ib] - 1) * 20;
            double dB = B / (double)(n - 1);
            double base = this.bands[ib][0];
            for (int i = 0; i < n; ++i) {
                double Omega = base + dB * (double)i;
                gridArray.add(Omega);
                if (i % 20 == 0) {
                    perturbation = i != 0 && i != n - 1 ? R.nextInt(3) - 1 : 0;
                    G.extremaIndices[extremum++] = gridpt + perturbation;
                }
                if (i == 0 || i == n - 1) {
                    G.bandEdgeIndices[bandEdgeCount] = gridpt;
                    ++bandEdgeCount;
                }
                ++gridpt;
            }
        }
        G.gridSize = gridArray.size();
        G.grid = new double[G.gridSize];
        G.X = new double[G.gridSize];
        G.H = new double[G.gridSize];
        G.W = new double[G.gridSize];
        for (int i = 0; i < G.gridSize; ++i) {
            G.grid[i] = (Double)gridArray.get(i);
            G.X[i] = Math.cos(G.grid[i] * Math.PI);
        }
        return G;
    }

    abstract void populateGrid(DesignGrid var1);

    abstract double desiredResponse(double var1);

    abstract double weight(double var1);

    abstract float[] interpretCoefficients(float[] var1);

    public void generateCoefficients() {
        DesignGrid G = this.createGrid();
        this.populateGrid(G);
        EquirippleDesigner.remez(G);
        this.coefficients = this.interpretCoefficients(EquirippleDesigner.calculateCoefficients(G, this.Nc));
    }

    public float[] getCoefficients() {
        return (float[])this.coefficients.clone();
    }

    public OverlapAdd getImplementation(int blockSize) {
        return new OverlapAdd(this.getCoefficients(), blockSize);
    }

    public float[] filter(float[] x) {
        int nfft = 16;
        int log2nfft = 4;
        int n = x.length + this.coefficients.length - 1;
        while (nfft < n) {
            nfft *= 2;
            ++log2nfft;
        }
        RDFT fft = new RDFT(log2nfft);
        float[] tmp = new float[nfft];
        float[] transform = new float[nfft];
        float[] kernel = new float[nfft];
        System.arraycopy(x, 0, tmp, 0, x.length);
        fft.evaluate(tmp, transform);
        Arrays.fill(tmp, 0.0f);
        System.arraycopy(this.coefficients, 0, tmp, 0, this.coefficients.length);
        fft.evaluate(tmp, kernel);
        RDFT.dftProduct(kernel, transform, 1.0f);
        fft.evaluateInverse(transform, tmp);
        kernel = new float[n];
        System.arraycopy(tmp, 0, kernel, 0, n);
        return kernel;
    }

    protected boolean LTE(double x, double y) {
        boolean retval = false;
        if (x < y) {
            retval = true;
        }
        if (Math.abs(x - y) < MACHINETOLERANCE) {
            retval = true;
        }
        return retval;
    }
}

