/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.fft.RDFT;
import com.oregondsp.signalProcessing.filter.LagrangePolynomial;
import com.oregondsp.signalProcessing.filter.fir.equiripple.DesignGrid;
import java.util.ArrayList;

class EquirippleDesigner {
    private static final int MAXITER = 25;

    EquirippleDesigner() {
    }

    static void remez(DesignGrid G) {
        int nextrema = G.extremaIndices.length;
        ArrayList<Integer> newExtrema = new ArrayList<Integer>();
        double[] E = new double[G.gridSize];
        double[] GA = new double[G.gridSize];
        int niter = 0;
        do {
            double delta = EquirippleDesigner.computeDelta(G);
            System.out.println("delta: " + delta);
            LagrangePolynomial LP = EquirippleDesigner.constructInterpolatingPolynomial(G, delta);
            for (int i = 0; i < G.gridSize; ++i) {
                GA[i] = LP.evaluate(G.X[i]);
                E[i] = GA[i] - G.H[i];
            }
            newExtrema.clear();
            int change = 0;
            for (int currentExtremum = 0; currentExtremum < nextrema; ++currentExtremum) {
                int currentGridPt = G.extremaIndices[currentExtremum];
                int s = EquirippleDesigner.sgn(E[currentGridPt]);
                int ptr = currentGridPt + 1;
                if (ptr < G.gridSize) {
                    while (EquirippleDesigner.sgn(E[ptr] - E[ptr - 1]) == s && ++ptr != G.gridSize) {
                    }
                }
                if (--ptr == currentGridPt) {
                    ptr = currentGridPt - 1;
                    if (ptr >= 0) {
                        while (EquirippleDesigner.sgn(E[ptr] - E[ptr + 1]) == s && --ptr >= 0) {
                        }
                    }
                    ++ptr;
                }
                newExtrema.add(ptr);
                if (ptr == currentGridPt) continue;
                ++change;
            }
            if (G.containsZero && G.containsPi) {
                int gridPi = G.gridSize - 1;
                if (newExtrema.contains(0)) {
                    if (!newExtrema.contains(gridPi) && EquirippleDesigner.sgn(E[gridPi]) != EquirippleDesigner.sgn(E[G.extremaIndices[nextrema - 1]]) && Math.abs(E[gridPi]) > Math.abs(E[0])) {
                        newExtrema.remove(0);
                        newExtrema.add(gridPi);
                        ++change;
                    }
                } else if (newExtrema.contains(gridPi) && EquirippleDesigner.sgn(E[0]) != EquirippleDesigner.sgn(E[G.extremaIndices[0]]) && Math.abs(E[0]) > Math.abs(E[gridPi])) {
                    newExtrema.remove(newExtrema.size() - 1);
                    newExtrema.add(0, 0);
                    ++change;
                }
            }
            if (change == 0) break;
            for (int i = 0; i < nextrema; ++i) {
                G.extremaIndices[i] = (Integer)newExtrema.get(i);
            }
        } while (++niter < 25);
    }

    static double computeDelta(DesignGrid G) {
        int nextrema = G.extremaIndices.length;
        double[] extrema = new double[nextrema];
        for (int i = 0; i < nextrema; ++i) {
            extrema[i] = G.X[G.extremaIndices[i]];
        }
        double[] gamma = LagrangePolynomial.BarycentricWeights(extrema);
        for (int i = 0; i < gamma.length; ++i) {
            if (Double.isFinite(gamma[i])) continue;
            throw new RuntimeException(" gamma[" + i + "] is not finite, will cause nom NaN: " + gamma[i]);
        }
        double num = 0.0;
        double denom = 0.0;
        double s = 1.0;
        for (int i = 0; i < nextrema; ++i) {
            int j = G.extremaIndices[i];
            if (!Double.isFinite(G.H[j])) {
                throw new RuntimeException("i=" + i + " G.H[" + j + "] is not finite, will cause nom NaN");
            }
            if (!Double.isFinite(gamma[i])) {
                throw new RuntimeException("i=" + i + " gamma[" + i + "] is not finite, will cause nom NaN");
            }
            num += gamma[i] * G.H[j];
            if (G.W[j] == 0.0) {
                throw new RuntimeException("G.W[" + j + "] is 0, will cause NaN");
            }
            denom += s * gamma[i] / G.W[j];
            s = -s;
        }
        if (denom == 0.0) {
            throw new RuntimeException("denom is 0, will cause NaN");
        }
        if (!Double.isFinite(num)) {
            throw new RuntimeException("num is not finite, will cause NaN");
        }
        if (!Double.isFinite(denom)) {
            throw new RuntimeException("denom is not finite, will cause NaN");
        }
        return num / denom;
    }

    static LagrangePolynomial constructInterpolatingPolynomial(DesignGrid G, double delta) {
        double[] extremaSubset = new double[G.extremaIndices.length - 1];
        int n = extremaSubset.length;
        double[] x = new double[n];
        double[] f = new double[n];
        double s = 1.0;
        for (int i = 0; i < n; ++i) {
            int j = G.extremaIndices[i];
            x[i] = G.X[j];
            f[i] = G.H[j] - s * delta / G.W[j];
            s = -s;
        }
        return new LagrangePolynomial(x, f);
    }

    static float[] calculateCoefficients(DesignGrid G, int Nc) {
        LagrangePolynomial LP = EquirippleDesigner.constructInterpolatingPolynomial(G, EquirippleDesigner.computeDelta(G));
        int log2nfft = 6;
        int nfft = 64;
        while (nfft < Nc) {
            nfft *= 2;
            ++log2nfft;
        }
        float[] X = new float[nfft];
        float[] x = new float[nfft];
        for (int i = 0; i <= nfft / 2; ++i) {
            X[i] = (float)LP.evaluate(Math.cos(Math.PI * 2 * (double)i / (double)nfft));
        }
        RDFT dft = new RDFT(log2nfft);
        dft.evaluateInverse(X, x);
        return x;
    }

    static int sgn(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }
}

