/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeI;

public class EquirippleBandpass
extends FIRTypeI {
    private double Wp;
    private double Ws1;
    private double Ws2;

    public EquirippleBandpass(int N, double OmegaS1, double Ws1, double OmegaP1, double OmegaP2, double Wp, double OmegaS2, double Ws2) {
        super(3, N);
        if (!(0.0 < OmegaS1 && OmegaS1 < OmegaP1 && OmegaP1 < OmegaP2 && OmegaP2 < OmegaS2 && OmegaS2 < 1.0)) {
            throw new IllegalArgumentException("Band edge specification error, ensure that 0.0 < OmegaS1 < OmegaP1 < OmegaP2 < OmegaS2 < 1.0");
        }
        this.bands[0][0] = 0.0;
        this.bands[0][1] = OmegaS1;
        this.bands[1][0] = OmegaP1;
        this.bands[1][1] = OmegaP2;
        this.bands[2][0] = OmegaS2;
        this.bands[2][1] = 1.0;
        this.Wp = Wp;
        this.Ws1 = Ws1;
        this.Ws2 = Ws2;
        this.generateCoefficients();
    }

    @Override
    double desiredResponse(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[1][0], Omega) && this.LTE(Omega, this.bands[1][1])) {
            retval = 1.0;
        }
        return retval;
    }

    @Override
    double weight(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = this.Ws1;
        } else if (this.LTE(this.bands[1][0], Omega) && this.LTE(Omega, this.bands[1][1])) {
            retval = this.Wp;
        } else if (this.LTE(this.bands[2][0], Omega) && this.LTE(Omega, this.bands[2][1])) {
            retval = this.Ws2;
        }
        return retval;
    }
}

