/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeIII;

public class CenteredHilbertTransform
extends FIRTypeIII {
    public CenteredHilbertTransform(int N, double Omega1, double Omega2) {
        super(1, N);
        if (!(0.0 < Omega1 && Omega1 < Omega2 && Omega2 < 1.0)) {
            throw new IllegalArgumentException("Check 0.0 < Omega1 < Omega2 < 1.0");
        }
        this.bands[0][0] = Omega1;
        this.bands[0][1] = Omega2;
        this.generateCoefficients();
    }

    @Override
    double desiredResponse(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = 1.0;
        }
        return retval;
    }

    @Override
    double weight(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = 1.0;
        }
        return retval;
    }
}

