/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeIII;

public class CenteredDifferentiator
extends FIRTypeIII {
    private double delta;

    public CenteredDifferentiator(int N, double delta, double OmegaP) {
        super(1, N);
        if (!(0.0 < OmegaP) || !(OmegaP < 1.0)) {
            throw new IllegalArgumentException("Check 0.0 < OmegaP < 1.0");
        }
        this.bands[0][0] = 1.0 / (double)(2 * N);
        this.bands[0][1] = OmegaP;
        this.delta = delta;
        this.generateCoefficients();
    }

    @Override
    double desiredResponse(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = -Math.PI * Omega / this.delta;
        }
        return retval;
    }

    @Override
    double weight(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = 1.0 / Omega;
        }
        return retval;
    }
}

