/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir;

import com.oregondsp.signalProcessing.Sequence;
import com.oregondsp.signalProcessing.fft.RDFT;
import java.util.Arrays;

public class OverlapAdd {
    private float[] shiftRegister;
    private RDFT fft;
    private int nfft;
    private float[] kernel;
    private int kernelLength;
    private int blockSize;
    private float[] segment;
    private float[] transform;

    public OverlapAdd(float[] H, int blockSize) {
        this.kernelLength = H.length;
        this.blockSize = blockSize;
        int clength = H.length + blockSize - 1;
        int log2nfft = 0;
        this.nfft = 1;
        while (this.nfft < clength) {
            ++log2nfft;
            this.nfft *= 2;
        }
        this.fft = new RDFT(log2nfft);
        this.shiftRegister = new float[this.nfft];
        this.kernel = new float[this.nfft];
        this.segment = new float[this.nfft];
        this.transform = new float[this.nfft];
        System.arraycopy(H, 0, this.segment, 0, H.length);
        this.fft.evaluate(this.segment, this.kernel);
    }

    public OverlapAdd(float[] H, OverlapAdd master) {
        if (H.length != master.kernelLength) {
            throw new IllegalArgumentException("Slave kernel length inconsistent with master OverlapAdd kernel length");
        }
        this.kernelLength = H.length;
        this.blockSize = master.blockSize;
        this.fft = master.fft;
        this.nfft = master.nfft;
        this.shiftRegister = new float[this.nfft];
        this.kernel = new float[this.nfft];
        this.segment = new float[this.nfft];
        this.transform = new float[this.nfft];
        System.arraycopy(H, 0, this.segment, 0, H.length);
        this.fft.evaluate(this.segment, this.kernel);
    }

    public void filter(float[] src, int sptr, float[] dst, int dptr) {
        if (src.length != this.blockSize) {
            throw new IllegalArgumentException("Data array length not equal to blockSize");
        }
        Arrays.fill(this.segment, 0.0f);
        System.arraycopy(src, sptr, this.segment, 0, this.blockSize);
        this.fft.evaluate(this.segment, this.transform);
        RDFT.dftProduct(this.kernel, this.transform, 1.0f);
        this.fft.evaluateInverse(this.transform, this.segment);
        for (int i = 0; i < this.nfft; ++i) {
            int n = i;
            this.shiftRegister[n] = this.shiftRegister[n] + this.segment[i];
        }
        System.arraycopy(this.shiftRegister, 0, dst, dptr, this.blockSize);
        Sequence.zeroShift(this.shiftRegister, -this.blockSize);
    }

    public void flush(float[] dst, int dptr) {
        System.arraycopy(this.shiftRegister, 0, dst, dptr, this.blockSize);
        Sequence.zeroShift(this.shiftRegister, -this.blockSize);
    }
}

