/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir;

import com.oregondsp.signalProcessing.HammingWindow;
import com.oregondsp.signalProcessing.Sequence;
import com.oregondsp.signalProcessing.filter.fir.OverlapAdd;

public class Interpolator {
    private int rate;
    private OverlapAdd overlapAdd;
    private float[] buffer;

    public Interpolator(int rate, int designFactor, int blockSize) {
        this.rate = rate;
        int half = rate * designFactor;
        int N = 2 * half + 1;
        float[] kernel = new HammingWindow(N).getArray();
        for (int i = 1; i <= half; ++i) {
            int n = half + i;
            kernel[n] = kernel[n] * (float)(Math.sin(Math.PI * (double)i / (double)rate) / (Math.PI * (double)i / (double)rate));
            kernel[half - i] = kernel[half + i];
        }
        this.overlapAdd = new OverlapAdd(kernel, blockSize * rate);
        this.buffer = new float[blockSize * rate];
    }

    public void interpolate(float[] block, float[] interpolatedBlock) {
        Sequence.stretch(block, this.rate, this.buffer);
        this.overlapAdd.filter(this.buffer, 0, interpolatedBlock, 0);
    }
}

