/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir;

import com.oregondsp.signalProcessing.Sequence;
import com.oregondsp.signalProcessing.filter.fir.equiripple.CenteredHilbertTransform;

public class ComplexAnalyticSignal {
    float[] realPart;
    float[] imagPart;

    public ComplexAnalyticSignal(float[] realSignal) {
        this.realPart = (float[])realSignal.clone();
        CenteredHilbertTransform transformer = new CenteredHilbertTransform(50, 0.03, 0.97);
        float[] tmp = transformer.filter(this.realPart);
        Sequence.zeroShift(tmp, -50);
        this.imagPart = new float[this.realPart.length];
        System.arraycopy(tmp, 0, this.imagPart, 0, this.realPart.length);
    }

    public float[] getEnvelope() {
        float[] retval = new float[this.realPart.length];
        for (int i = 0; i < this.realPart.length; ++i) {
            retval[i] = (float)Math.sqrt(this.realPart[i] * this.realPart[i] + this.imagPart[i] * this.imagPart[i]);
        }
        return retval;
    }

    float[] getRealPart() {
        return (float[])this.realPart.clone();
    }

    float[] getImagPart() {
        return (float[])this.imagPart.clone();
    }
}

