/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter;

import com.oregondsp.signalProcessing.filter.Polynomial;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import java.io.PrintStream;

public class Rational {
    private Polynomial N;
    private Polynomial D;

    public Rational(double[] num, double[] denom) {
        this.N = new Polynomial(num);
        this.D = new Polynomial(denom);
    }

    public Rational(Polynomial N, Polynomial D) {
        this.N = new Polynomial(N);
        this.D = new Polynomial(D);
    }

    public Rational(Rational R) {
        this.N = new Polynomial(R.N);
        this.D = new Polynomial(R.D);
    }

    public Rational(double c) {
        this.N = new Polynomial(c);
        this.D = new Polynomial(1.0);
    }

    public int[] order() {
        int[] retval = new int[]{this.N.order(), this.D.order()};
        return retval;
    }

    public Polynomial numerator() {
        return new Polynomial(this.N);
    }

    public Polynomial denominator() {
        return new Polynomial(this.D);
    }

    public double canonicalForm() {
        double scaleN = this.N.a[this.N.order];
        int i = 0;
        while (i < this.N.a.length) {
            int n = i++;
            this.N.a[n] = this.N.a[n] / scaleN;
        }
        double scaleD = this.D.a[this.D.order];
        int i2 = 0;
        while (i2 < this.D.a.length) {
            int n = i2++;
            this.D.a[n] = this.D.a[n] / scaleD;
        }
        return scaleN / scaleD;
    }

    public void timesEquals(double A) {
        this.N.timesEquals(A);
    }

    public void timesEquals(Polynomial P) {
        this.N.timesEquals(P);
    }

    public void timesEquals(Rational R) {
        this.N.timesEquals(R.N);
        this.D.timesEquals(R.D);
    }

    public double evaluate(double x) {
        double retval = 0.0;
        double num = this.N.evaluate(x);
        double denom = this.D.evaluate(x);
        if (denom != 0.0) {
            retval = num / denom;
        }
        return retval;
    }

    public Complex evaluate(Complex c) {
        Complex retval = new Complex(0.0, 0.0);
        Complex num = this.N.evaluate(c);
        Complex denom = this.D.evaluate(c);
        if (denom.abs() != 0.0) {
            retval = num.over(denom);
        }
        return retval;
    }

    public Rational map(Rational S) {
        int i;
        Polynomial P = new Polynomial(this.N.a[this.N.order]);
        Polynomial T = new Polynomial(1.0);
        for (int i2 = this.N.order - 1; i2 >= 0; --i2) {
            T = T.times(S.D);
            P = P.times(S.N).plus(T.times(this.N.a[i2]));
        }
        Polynomial Q = new Polynomial(this.D.a[this.D.order]);
        T = new Polynomial(1.0);
        for (i = this.D.order - 1; i >= 0; --i) {
            T = T.times(S.D);
            Q = Q.times(S.N).plus(T.times(this.D.a[i]));
        }
        if (this.D.order > this.N.order) {
            for (i = 0; i < this.D.order - this.N.order; ++i) {
                P = P.times(S.D);
            }
        } else if (this.N.order > this.D.order) {
            for (i = 0; i < this.N.order - this.D.order; ++i) {
                Q = Q.times(S.D);
            }
        }
        P.trim();
        Q.trim();
        return new Rational(P, Q);
    }

    public double residue(double pole) {
        return this.N.evaluate(pole) / this.D.derivative().evaluate(pole);
    }

    public Complex residue(Complex pole) {
        return this.N.evaluate(pole).over(this.D.derivative().evaluate(pole));
    }

    public double groupDelay(double omega) {
        return this.N.groupDelay(omega) - this.D.groupDelay(omega);
    }

    public double discreteTimeGroupDelay(double Omega) {
        return this.N.discreteTimeGroupDelay(Omega) - this.D.discreteTimeGroupDelay(Omega);
    }

    public void print(PrintStream ps) {
        ps.println("Numerator: ");
        this.N.print(ps);
        ps.println("Denominator: ");
        this.D.print(ps);
    }

    public static void main(String[] args) {
        double[] a = new double[]{1.0, 2.0, 2.0, 1.0};
        double[] b = new double[]{1.0};
        Rational R = new Rational(b, a);
        for (int i = 0; i < 100; ++i) {
            double omega = (double)i / 25.0;
            System.out.println(omega + "  " + R.evaluate(new Complex(0.0, omega)).abs() + "   " + R.groupDelay(omega));
        }
    }
}

