/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter;

import com.oregondsp.signalProcessing.filter.Rational;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import java.io.PrintStream;
import java.util.Arrays;

public class Polynomial {
    protected double[] a;
    protected int order;

    public Polynomial(double[] a) {
        this.order = a.length - 1;
        this.a = new double[a.length];
        System.arraycopy(a, 0, this.a, 0, a.length);
    }

    public Polynomial(Polynomial B) {
        this.order = B.order;
        this.a = new double[this.order + 1];
        System.arraycopy(B.a, 0, this.a, 0, this.a.length);
    }

    public Polynomial(int order) {
        this.order = order;
        this.a = new double[order + 1];
        Arrays.fill(this.a, 0.0);
    }

    public Polynomial(double c) {
        this.order = 0;
        this.a = new double[1];
        this.a[0] = c;
    }

    public void trim() {
        int i = this.order;
        int n = 0;
        while (this.a[i] == 0.0) {
            ++n;
            --i;
        }
        if (n > 0) {
            double[] b = new double[this.order + 1 - n];
            System.arraycopy(this.a, 0, b, 0, this.a.length - n);
            this.a = b;
            this.order -= n;
        }
    }

    public int order() {
        return this.order;
    }

    public double[] coefficients() {
        double[] retval = new double[this.order + 1];
        System.arraycopy(this.a, 0, retval, 0, this.order + 1);
        return retval;
    }

    public Polynomial plus(double c) {
        Polynomial retval = new Polynomial(this.order);
        System.arraycopy(this.a, 0, retval.a, 0, this.a.length);
        retval.a[0] = retval.a[0] + c;
        return retval;
    }

    public void plusEquals(double c) {
        this.a[0] = this.a[0] + c;
    }

    public Polynomial plus(Polynomial B) {
        int i;
        Polynomial retval = new Polynomial(Math.max(this.order, B.order));
        for (i = 0; i <= this.order; ++i) {
            retval.a[i] = this.a[i];
        }
        for (i = 0; i <= B.order; ++i) {
            int n = i;
            retval.a[n] = retval.a[n] + B.a[i];
        }
        return retval;
    }

    public void plusEquals(Polynomial B) {
        int i;
        double[] A = new double[Math.max(this.order, B.order)];
        for (i = 0; i <= this.order; ++i) {
            A[i] = this.a[i];
        }
        for (i = 0; i <= B.order; ++i) {
            int n = i;
            A[n] = A[n] + B.a[i];
        }
        this.a = A;
        this.order = A.length - 1;
    }

    public Polynomial minus(double c) {
        return this.plus(-c);
    }

    public void minusEquals(double c) {
        this.plusEquals(-c);
    }

    public Polynomial minus(Polynomial B) {
        int i;
        Polynomial retval = new Polynomial(Math.max(this.order, B.order));
        for (i = 0; i <= this.order; ++i) {
            retval.a[i] = this.a[i];
        }
        for (i = 0; i <= B.order; ++i) {
            int n = i;
            retval.a[n] = retval.a[n] - B.a[i];
        }
        return retval;
    }

    public void minusEquals(Polynomial B) {
        int i;
        double[] A = new double[Math.max(this.order, B.order)];
        for (i = 0; i <= this.order; ++i) {
            A[i] = this.a[i];
        }
        for (i = 0; i <= B.order; ++i) {
            int n = i;
            A[n] = A[n] - B.a[i];
        }
        this.a = A;
        this.order = A.length - 1;
    }

    public Polynomial times(double c) {
        Polynomial retval = new Polynomial(this.order);
        for (int i = 0; i <= this.order; ++i) {
            retval.a[i] = c * this.a[i];
        }
        return retval;
    }

    public void timesEquals(double c) {
        int i = 0;
        while (i <= this.order) {
            int n = i++;
            this.a[n] = this.a[n] * c;
        }
    }

    public Polynomial times(Polynomial B) {
        double[] b = B.a;
        double[] prod = new double[this.order + B.order + 1];
        Arrays.fill(prod, 0.0);
        for (int i = 0; i <= B.order; ++i) {
            for (int j = 0; j <= this.order; ++j) {
                int n = i + j;
                prod[n] = prod[n] + b[i] * this.a[j];
            }
        }
        return new Polynomial(prod);
    }

    public void timesEquals(Polynomial B) {
        double[] b = B.a;
        double[] prod = new double[this.order + B.order + 1];
        Arrays.fill(prod, 0.0);
        for (int i = 0; i <= B.order; ++i) {
            for (int j = 0; j <= this.order; ++j) {
                int n = i + j;
                prod[n] = prod[n] + b[i] * this.a[j];
            }
        }
        this.a = prod;
        this.order += B.order;
    }

    public Polynomial over(double c) {
        double[] tmp = new double[this.order + 1];
        for (int i = 0; i < this.order + 1; ++i) {
            tmp[i] = this.a[i] / c;
        }
        return new Polynomial(tmp);
    }

    public void overEquals(double c) {
        int i = 0;
        while (i < this.order + 1) {
            int n = i++;
            this.a[n] = this.a[n] / c;
        }
    }

    public Rational over(Polynomial B) {
        return new Rational(this, B);
    }

    public Polynomial derivative() {
        double[] tmp = new double[this.order];
        for (int i = 0; i < this.order; ++i) {
            tmp[i] = (double)(i + 1) * this.a[i + 1];
        }
        return new Polynomial(tmp);
    }

    public double evaluate(double x) {
        double retval = this.a[this.order];
        for (int i = this.order - 1; i >= 0; --i) {
            retval = x * retval + this.a[i];
        }
        return retval;
    }

    public Complex evaluate(Complex c) {
        Complex retval = new Complex(this.a[this.order]);
        for (int i = this.order - 1; i >= 0; --i) {
            retval = retval.times(c).plus(this.a[i]);
        }
        return retval;
    }

    public double groupDelay(double omega) {
        if (this.order == 0) {
            return 0.0;
        }
        Complex c = new Complex(0.0, omega);
        Complex N = this.derivative().evaluate(c);
        Complex D = this.evaluate(c);
        return -N.over(D).real();
    }

    public double discreteTimeGroupDelay(double Omega) {
        Complex c = Complex.exp(new Complex(0.0, -Omega));
        Complex N = new Complex(this.a[this.order] * (double)this.order);
        for (int i = this.order - 1; i >= 0; --i) {
            N = N.times(c).plus(this.a[i] * (double)i);
        }
        Complex D = this.evaluate(c);
        return N.over(D).real();
    }

    public double[] reflectionCoefficients() {
        double[] k = new double[this.order];
        double[] b = new double[this.order + 1];
        b[0] = 1.0;
        for (int i = 0; i < this.order; ++i) {
            b[i + 1] = this.a[i + 1] / this.a[0];
        }
        double[] c = new double[this.order];
        for (int i = this.order; i > 0; --i) {
            k[i - 1] = b[i];
            double scale = 1.0 - k[i - 1] * k[i - 1];
            Arrays.fill(c, 0.0);
            for (int j = 0; j < i; ++j) {
                c[j] = (b[j] - k[i - 1] * b[i - j]) / scale;
            }
            System.arraycopy(c, 0, b, 0, i);
        }
        return k;
    }

    public void print(PrintStream ps) {
        for (int i = 0; i <= this.order; ++i) {
            if (i >= 0 && i < 10) {
                ps.println(i + "    " + this.a[i]);
                continue;
            }
            if (i < 10 || i > 100) continue;
            ps.println(i + "   " + this.a[i]);
        }
    }
}

