/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter;

import com.oregondsp.signalProcessing.filter.Polynomial;

public class LagrangePolynomial {
    private int order;
    private double[] x;
    private double[] y;
    private double[] weights;

    public LagrangePolynomial(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Lengths of x and y arrays do not match");
        }
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
        this.order = x.length - 1;
        this.weights = LagrangePolynomial.BarycentricWeights(x);
    }

    public int order() {
        return this.order;
    }

    public double evaluate(double xp) {
        double num = 0.0;
        double denom = 0.0;
        for (int j = 0; j <= this.order; ++j) {
            if (xp == this.x[j]) {
                num = this.y[j];
                denom = 1.0;
                break;
            }
            double term = this.weights[j] / (xp - this.x[j]);
            num += term * this.y[j];
            denom += term;
        }
        return num / denom;
    }

    public static double[] BarycentricWeights(double[] z) {
        int n = z.length;
        double[] retval = new double[n];
        for (int j = 0; j < n; ++j) {
            double w = 1.0;
            for (int i = 0; i < n; ++i) {
                if (i == j) continue;
                w *= z[j] - z[i];
            }
            retval[j] = 1.0 / w;
        }
        return retval;
    }

    public double[] ChebyshevNodes(double a, double b, int n) {
        double t0 = (a + b) / 2.0;
        double t1 = (b - 1.0) / 2.0;
        double[] retval = new double[n];
        for (int i = 0; i < n; ++i) {
            retval[i] = t0 + t1 * Math.cos((double)((2 * i + 1) / (2 * n)) * Math.PI);
        }
        return retval;
    }

    public static void main(String[] args) {
        double[] p = new double[]{6.0, -11.0, 6.0};
        Polynomial P = new Polynomial(p);
        double[] x = new double[]{1.0, 2.0, 3.0};
        double[] f = new double[]{1.0, 8.0, 27.0};
        LagrangePolynomial L = new LagrangePolynomial(x, f);
        for (int i = 0; i < 21; ++i) {
            double z = 1.0 + (double)i * 0.1;
            System.out.println(P.evaluate(z) + "  " + L.evaluate(z));
        }
    }
}

