/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.fft;

import com.oregondsp.signalProcessing.fft.CDFT;

public class RDFT {
    private int N;
    private int N2;
    private int N4;
    private float[] xr;
    private float[] xi;
    private float[] Xr;
    private float[] Xi;
    private CDFT dft;
    private float[] c;
    private float[] s;

    public RDFT(int log2N) {
        if (log2N < 4) {
            throw new IllegalArgumentException("DFT size must be >= 16");
        }
        this.N = 1 << log2N;
        this.N2 = this.N / 2;
        this.N4 = this.N / 4;
        this.xr = new float[this.N2];
        this.xi = new float[this.N2];
        this.Xr = new float[this.N2];
        this.Xi = new float[this.N2];
        this.s = new float[this.N4];
        this.c = new float[this.N4];
        for (int i = 0; i < this.N4; ++i) {
            this.s[i] = (float)Math.sin(Math.PI * 2 / (double)this.N * (double)i);
            this.c[i] = (float)Math.cos(Math.PI * 2 / (double)this.N * (double)i);
        }
        this.dft = new CDFT(log2N - 1);
    }

    public void evaluate(float[] x, float[] X) {
        for (int i = 0; i < this.N2; ++i) {
            int j = i << 1;
            this.xr[i] = x[j++];
            this.xi[i] = x[j];
        }
        this.dft.evaluate(this.xr, this.xi, this.Xr, this.Xi);
        X[0] = this.Xr[0] + this.Xi[0];
        X[this.N2] = this.Xr[0] - this.Xi[0];
        int N2pk = this.N2 + 1;
        int N2mk = this.N2 - 1;
        int Nmk = this.N - 1;
        for (int k = 1; k < this.N4; ++k) {
            float Xrk = this.Xr[k];
            float Xik = this.Xi[k];
            float XrN2mk = this.Xr[N2mk];
            float XiN2mk = this.Xi[N2mk];
            float Sr = (Xrk + XrN2mk) / 2.0f;
            float Si = (Xik - XiN2mk) / 2.0f;
            float Dr = (Xik + XiN2mk) / 2.0f;
            float Di = (XrN2mk - Xrk) / 2.0f;
            float tmp = this.c[k] * Dr + this.s[k] * Di;
            Di = this.c[k] * Di - this.s[k] * Dr;
            Dr = tmp;
            X[k] = Sr + Dr;
            X[Nmk] = Si + Di;
            X[N2mk] = Sr - Dr;
            X[N2pk] = Di - Si;
            ++N2pk;
            --N2mk;
            --Nmk;
        }
        X[this.N4] = this.Xr[this.N4];
        X[this.N2 + this.N4] = -this.Xi[this.N4];
    }

    public void evaluateInverse(float[] X, float[] x) {
        this.Xr[0] = X[0] + X[this.N2];
        this.Xi[0] = X[0] - X[this.N2];
        int N2pk = this.N2 + 1;
        int N2mk = this.N2 - 1;
        int Nmk = this.N - 1;
        for (int k = 1; k < this.N4; ++k) {
            float Xrk = X[k];
            float Xik = X[Nmk];
            float XrkpN2 = X[N2mk];
            float XikpN2 = -X[N2pk];
            float Dr = Xrk - XrkpN2;
            float Di = Xik - XikpN2;
            this.Xr[k] = Xrk + XrkpN2 - this.s[k] * Dr - this.c[k] * Di;
            this.Xi[k] = Xik + XikpN2 + this.c[k] * Dr - this.s[k] * Di;
            ++N2pk;
            --N2mk;
            --Nmk;
        }
        this.Xr[this.N4] = 2.0f * X[this.N4];
        this.Xi[this.N4] = -2.0f * X[this.N2 + this.N4];
        N2pk = this.N2 + this.N4 + 1;
        N2mk = this.N4 - 1;
        Nmk = this.N - this.N4 - 1;
        int reflect = this.N4 - 1;
        for (int k = this.N4 + 1; k < this.N2; ++k) {
            float Xrk = X[k];
            float Xik = X[Nmk];
            float XrkpN2 = X[N2mk];
            float XikpN2 = -X[N2pk];
            float Dr = Xrk - XrkpN2;
            float Di = Xik - XikpN2;
            this.Xr[k] = Xrk + XrkpN2 - this.s[reflect] * Dr + this.c[reflect] * Di;
            this.Xi[k] = Xik + XikpN2 - this.c[reflect] * Dr - this.s[reflect] * Di;
            ++N2pk;
            --N2mk;
            --Nmk;
            --reflect;
        }
        this.dft.evaluate(this.Xr, this.Xi, this.xr, this.xi);
        x[0] = this.xr[0] / (float)this.N;
        x[1] = this.xi[0] / (float)this.N;
        int j = this.N2 - 1;
        for (int k = 1; k < this.N2; ++k) {
            int i = k << 1;
            x[i++] = this.xr[j] / (float)this.N;
            x[i] = this.xi[j] / (float)this.N;
            --j;
        }
    }

    public static void dftProduct(float[] kernel, float[] transform, float sign) {
        if (kernel.length != transform.length) {
            throw new IllegalArgumentException("kernel and transform arrays must have the same size");
        }
        int n = kernel.length;
        int half = n / 2;
        transform[0] = transform[0] * kernel[0];
        int n2 = half;
        transform[n2] = transform[n2] * kernel[half];
        for (int i = 1; i < half; ++i) {
            int im = n - i;
            float tmp = kernel[i] * transform[i] - sign * kernel[im] * transform[im];
            transform[im] = kernel[i] * transform[im] + sign * kernel[im] * transform[i];
            transform[i] = tmp;
        }
    }
}

