/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.fft;

import com.oregondsp.signalProcessing.fft.CDFTsr;

class CDFTsr8
extends CDFTsr {
    static final float SQRT2BY2 = (float)(Math.sqrt(2.0) / 2.0);
    private int n0;
    private int n1;
    private int n2;
    private int n3;
    private int n4;
    private int n5;
    private int n6;
    private int n7;
    private int m0;
    private int m1;
    private int m2;
    private int m3;
    private int m4;
    private int m5;
    private int m6;
    private int m7;

    CDFTsr8(int xoffset, int xstride, int Xoffset) {
        this.m = 3;
        this.N = 8;
        this.xoffset = xoffset;
        this.xstride = xstride;
        this.Xoffset = Xoffset;
        this.n0 = xoffset;
        this.n1 = this.n0 + xstride;
        this.n2 = this.n1 + xstride;
        this.n3 = this.n2 + xstride;
        this.n4 = this.n3 + xstride;
        this.n5 = this.n4 + xstride;
        this.n6 = this.n5 + xstride;
        this.n7 = this.n6 + xstride;
        this.m0 = Xoffset;
        this.m1 = this.m0 + 1;
        this.m2 = this.m1 + 1;
        this.m3 = this.m2 + 1;
        this.m4 = this.m3 + 1;
        this.m5 = this.m4 + 1;
        this.m6 = this.m5 + 1;
        this.m7 = this.m6 + 1;
    }

    @Override
    void link(float[] xr, float[] xi, float[] Xr, float[] Xi) {
        this.xr = xr;
        this.xi = xi;
        this.Xr = Xr;
        this.Xi = Xi;
    }

    @Override
    void evaluate() {
        this.Xr[this.m0] = this.xr[this.n0] + this.xr[this.n4];
        this.Xi[this.m0] = this.xi[this.n0] + this.xi[this.n4];
        this.Xr[this.m1] = this.xr[this.n0] - this.xr[this.n4];
        this.Xi[this.m1] = this.xi[this.n0] - this.xi[this.n4];
        float Rr = this.xr[this.n2] + this.xr[this.n6];
        float Ri = this.xi[this.n2] + this.xi[this.n6];
        float Sr = this.xi[this.n6] - this.xi[this.n2];
        float Si = this.xr[this.n2] - this.xr[this.n6];
        this.Xr[this.m2] = this.Xr[this.m0] - Rr;
        this.Xi[this.m2] = this.Xi[this.m0] - Ri;
        this.Xr[this.m3] = this.Xr[this.m1] + Sr;
        this.Xi[this.m3] = this.Xi[this.m1] + Si;
        int n = this.m0;
        this.Xr[n] = this.Xr[n] + Rr;
        int n2 = this.m0;
        this.Xi[n2] = this.Xi[n2] + Ri;
        int n3 = this.m1;
        this.Xr[n3] = this.Xr[n3] - Sr;
        int n4 = this.m1;
        this.Xi[n4] = this.Xi[n4] - Si;
        this.Xr[this.m4] = this.xr[this.n1] + this.xr[this.n5];
        this.Xi[this.m4] = this.xi[this.n1] + this.xi[this.n5];
        this.Xr[this.m5] = this.xr[this.n1] - this.xr[this.n5];
        this.Xi[this.m5] = this.xi[this.n1] - this.xi[this.n5];
        this.Xr[this.m6] = this.xr[this.n3] + this.xr[this.n7];
        this.Xi[this.m6] = this.xi[this.n3] + this.xi[this.n7];
        this.Xr[this.m7] = this.xr[this.n3] - this.xr[this.n7];
        this.Xi[this.m7] = this.xi[this.n3] - this.xi[this.n7];
        Rr = this.Xr[this.m4] + this.Xr[this.m6];
        Ri = this.Xi[this.m4] + this.Xi[this.m6];
        Sr = this.Xi[this.m6] - this.Xi[this.m4];
        Si = this.Xr[this.m4] - this.Xr[this.m6];
        this.Xr[this.m4] = this.Xr[this.m0] - Rr;
        this.Xi[this.m4] = this.Xi[this.m0] - Ri;
        this.Xr[this.m6] = this.Xr[this.m2] + Sr;
        this.Xi[this.m6] = this.Xi[this.m2] + Si;
        int n5 = this.m0;
        this.Xr[n5] = this.Xr[n5] + Rr;
        int n6 = this.m0;
        this.Xi[n6] = this.Xi[n6] + Ri;
        int n7 = this.m2;
        this.Xr[n7] = this.Xr[n7] - Sr;
        int n8 = this.m2;
        this.Xi[n8] = this.Xi[n8] - Si;
        float T1r = SQRT2BY2 * (this.Xr[this.m5] + this.Xi[this.m5]);
        float T1i = SQRT2BY2 * (this.Xi[this.m5] - this.Xr[this.m5]);
        float T3r = SQRT2BY2 * (this.Xi[this.m7] - this.Xr[this.m7]);
        float T3i = -SQRT2BY2 * (this.Xi[this.m7] + this.Xr[this.m7]);
        Rr = T1r + T3r;
        Ri = T1i + T3i;
        Sr = T3i - T1i;
        Si = T1r - T3r;
        this.Xr[this.m5] = this.Xr[this.m1] - Rr;
        this.Xi[this.m5] = this.Xi[this.m1] - Ri;
        this.Xr[this.m7] = this.Xr[this.m3] + Sr;
        this.Xi[this.m7] = this.Xi[this.m3] + Si;
        int n9 = this.m1;
        this.Xr[n9] = this.Xr[n9] + Rr;
        int n10 = this.m1;
        this.Xi[n10] = this.Xi[n10] + Ri;
        int n11 = this.m3;
        this.Xr[n11] = this.Xr[n11] - Sr;
        int n12 = this.m3;
        this.Xi[n12] = this.Xi[n12] - Si;
    }
}

