/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.fft;

import com.oregondsp.signalProcessing.fft.CDFTsr;

class CDFTsr16
extends CDFTsr {
    static final float C_1_16 = (float)Math.cos(0.39269908169872414);
    static final float C_3_16 = (float)Math.cos(1.1780972450961724);
    static final float SQRT2BY2 = (float)(Math.sqrt(2.0) / 2.0);
    private int n0;
    private int n1;
    private int n2;
    private int n3;
    private int n4;
    private int n5;
    private int n6;
    private int n7;
    private int n8;
    private int n9;
    private int n10;
    private int n11;
    private int n12;
    private int n13;
    private int n14;
    private int n15;
    private int m0;
    private int m1;
    private int m2;
    private int m3;
    private int m4;
    private int m5;
    private int m6;
    private int m7;
    private int m8;
    private int m9;
    private int m10;
    private int m11;
    private int m12;
    private int m13;
    private int m14;
    private int m15;

    CDFTsr16(int dataOffset, int dataStride, int transformOffset) {
        this.m = 4;
        this.N = 16;
        this.xoffset = dataOffset;
        this.xstride = dataStride;
        this.Xoffset = transformOffset;
        this.n0 = this.xoffset;
        this.n1 = this.n0 + this.xstride;
        this.n2 = this.n1 + this.xstride;
        this.n3 = this.n2 + this.xstride;
        this.n4 = this.n3 + this.xstride;
        this.n5 = this.n4 + this.xstride;
        this.n6 = this.n5 + this.xstride;
        this.n7 = this.n6 + this.xstride;
        this.n8 = this.n7 + this.xstride;
        this.n9 = this.n8 + this.xstride;
        this.n10 = this.n9 + this.xstride;
        this.n11 = this.n10 + this.xstride;
        this.n12 = this.n11 + this.xstride;
        this.n13 = this.n12 + this.xstride;
        this.n14 = this.n13 + this.xstride;
        this.n15 = this.n14 + this.xstride;
        this.m0 = this.Xoffset;
        this.m1 = this.m0 + 1;
        this.m2 = this.m1 + 1;
        this.m3 = this.m2 + 1;
        this.m4 = this.m3 + 1;
        this.m5 = this.m4 + 1;
        this.m6 = this.m5 + 1;
        this.m7 = this.m6 + 1;
        this.m8 = this.m7 + 1;
        this.m9 = this.m8 + 1;
        this.m10 = this.m9 + 1;
        this.m11 = this.m10 + 1;
        this.m12 = this.m11 + 1;
        this.m13 = this.m12 + 1;
        this.m14 = this.m13 + 1;
        this.m15 = this.m14 + 1;
    }

    @Override
    void link(float[] xr, float[] xi, float[] Xr, float[] Xi) {
        this.xr = xr;
        this.xi = xi;
        this.Xr = Xr;
        this.Xi = Xi;
    }

    @Override
    void evaluate() {
        this.Xr[this.m0] = this.xr[this.n0] + this.xr[this.n8];
        this.Xi[this.m0] = this.xi[this.n0] + this.xi[this.n8];
        this.Xr[this.m1] = this.xr[this.n0] - this.xr[this.n8];
        this.Xi[this.m1] = this.xi[this.n0] - this.xi[this.n8];
        float Rr = this.xr[this.n4] + this.xr[this.n12];
        float Ri = this.xi[this.n4] + this.xi[this.n12];
        float Sr = this.xi[this.n12] - this.xi[this.n4];
        float Si = this.xr[this.n4] - this.xr[this.n12];
        this.Xr[this.m2] = this.Xr[this.m0] - Rr;
        this.Xi[this.m2] = this.Xi[this.m0] - Ri;
        this.Xr[this.m3] = this.Xr[this.m1] + Sr;
        this.Xi[this.m3] = this.Xi[this.m1] + Si;
        int n = this.m0;
        this.Xr[n] = this.Xr[n] + Rr;
        int n2 = this.m0;
        this.Xi[n2] = this.Xi[n2] + Ri;
        int n3 = this.m1;
        this.Xr[n3] = this.Xr[n3] - Sr;
        int n4 = this.m1;
        this.Xi[n4] = this.Xi[n4] - Si;
        this.Xr[this.m4] = this.xr[this.n2] + this.xr[this.n10];
        this.Xi[this.m4] = this.xi[this.n2] + this.xi[this.n10];
        this.Xr[this.m5] = this.xr[this.n2] - this.xr[this.n10];
        this.Xi[this.m5] = this.xi[this.n2] - this.xi[this.n10];
        this.Xr[this.m6] = this.xr[this.n6] + this.xr[this.n14];
        this.Xi[this.m6] = this.xi[this.n6] + this.xi[this.n14];
        this.Xr[this.m7] = this.xr[this.n6] - this.xr[this.n14];
        this.Xi[this.m7] = this.xi[this.n6] - this.xi[this.n14];
        Rr = this.Xr[this.m4] + this.Xr[this.m6];
        Ri = this.Xi[this.m4] + this.Xi[this.m6];
        Sr = this.Xi[this.m6] - this.Xi[this.m4];
        Si = this.Xr[this.m4] - this.Xr[this.m6];
        this.Xr[this.m4] = this.Xr[this.m0] - Rr;
        this.Xi[this.m4] = this.Xi[this.m0] - Ri;
        this.Xr[this.m6] = this.Xr[this.m2] + Sr;
        this.Xi[this.m6] = this.Xi[this.m2] + Si;
        int n5 = this.m0;
        this.Xr[n5] = this.Xr[n5] + Rr;
        int n6 = this.m0;
        this.Xi[n6] = this.Xi[n6] + Ri;
        int n7 = this.m2;
        this.Xr[n7] = this.Xr[n7] - Sr;
        int n8 = this.m2;
        this.Xi[n8] = this.Xi[n8] - Si;
        float T1r = SQRT2BY2 * (this.Xr[this.m5] + this.Xi[this.m5]);
        float T1i = SQRT2BY2 * (this.Xi[this.m5] - this.Xr[this.m5]);
        float T3r = SQRT2BY2 * (this.Xi[this.m7] - this.Xr[this.m7]);
        float T3i = -SQRT2BY2 * (this.Xi[this.m7] + this.Xr[this.m7]);
        Rr = T1r + T3r;
        Ri = T1i + T3i;
        Sr = T3i - T1i;
        Si = T1r - T3r;
        this.Xr[this.m5] = this.Xr[this.m1] - Rr;
        this.Xi[this.m5] = this.Xi[this.m1] - Ri;
        this.Xr[this.m7] = this.Xr[this.m3] + Sr;
        this.Xi[this.m7] = this.Xi[this.m3] + Si;
        int n9 = this.m1;
        this.Xr[n9] = this.Xr[n9] + Rr;
        int n10 = this.m1;
        this.Xi[n10] = this.Xi[n10] + Ri;
        int n11 = this.m3;
        this.Xr[n11] = this.Xr[n11] - Sr;
        int n12 = this.m3;
        this.Xi[n12] = this.Xi[n12] - Si;
        this.Xr[this.m8] = this.xr[this.n1] + this.xr[this.n9];
        this.Xi[this.m8] = this.xi[this.n1] + this.xi[this.n9];
        this.Xr[this.m9] = this.xr[this.n1] - this.xr[this.n9];
        this.Xi[this.m9] = this.xi[this.n1] - this.xi[this.n9];
        Rr = this.xr[this.n5] + this.xr[this.n13];
        Ri = this.xi[this.n5] + this.xi[this.n13];
        Sr = this.xi[this.n13] - this.xi[this.n5];
        Si = this.xr[this.n5] - this.xr[this.n13];
        this.Xr[this.m10] = this.Xr[this.m8] - Rr;
        this.Xi[this.m10] = this.Xi[this.m8] - Ri;
        this.Xr[this.m11] = this.Xr[this.m9] + Sr;
        this.Xi[this.m11] = this.Xi[this.m9] + Si;
        int n13 = this.m8;
        this.Xr[n13] = this.Xr[n13] + Rr;
        int n14 = this.m8;
        this.Xi[n14] = this.Xi[n14] + Ri;
        int n15 = this.m9;
        this.Xr[n15] = this.Xr[n15] - Sr;
        int n16 = this.m9;
        this.Xi[n16] = this.Xi[n16] - Si;
        this.Xr[this.m12] = this.xr[this.n3] + this.xr[this.n11];
        this.Xi[this.m12] = this.xi[this.n3] + this.xi[this.n11];
        this.Xr[this.m13] = this.xr[this.n3] - this.xr[this.n11];
        this.Xi[this.m13] = this.xi[this.n3] - this.xi[this.n11];
        Rr = this.xr[this.n7] + this.xr[this.n15];
        Ri = this.xi[this.n7] + this.xi[this.n15];
        Sr = this.xi[this.n15] - this.xi[this.n7];
        Si = this.xr[this.n7] - this.xr[this.n15];
        this.Xr[this.m14] = this.Xr[this.m12] - Rr;
        this.Xi[this.m14] = this.Xi[this.m12] - Ri;
        this.Xr[this.m15] = this.Xr[this.m13] + Sr;
        this.Xi[this.m15] = this.Xi[this.m13] + Si;
        int n17 = this.m12;
        this.Xr[n17] = this.Xr[n17] + Rr;
        int n18 = this.m12;
        this.Xi[n18] = this.Xi[n18] + Ri;
        int n19 = this.m13;
        this.Xr[n19] = this.Xr[n19] - Sr;
        int n20 = this.m13;
        this.Xi[n20] = this.Xi[n20] - Si;
        Rr = this.Xr[this.m8] + this.Xr[this.m12];
        Ri = this.Xi[this.m8] + this.Xi[this.m12];
        Sr = this.Xi[this.m12] - this.Xi[this.m8];
        Si = this.Xr[this.m8] - this.Xr[this.m12];
        this.Xr[this.m8] = this.Xr[this.m0] - Rr;
        this.Xi[this.m8] = this.Xi[this.m0] - Ri;
        this.Xr[this.m12] = this.Xr[this.m4] + Sr;
        this.Xi[this.m12] = this.Xi[this.m4] + Si;
        int n21 = this.m0;
        this.Xr[n21] = this.Xr[n21] + Rr;
        int n22 = this.m0;
        this.Xi[n22] = this.Xi[n22] + Ri;
        int n23 = this.m4;
        this.Xr[n23] = this.Xr[n23] - Sr;
        int n24 = this.m4;
        this.Xi[n24] = this.Xi[n24] - Si;
        T1r = C_1_16 * this.Xr[this.m9] + C_3_16 * this.Xi[this.m9];
        T1i = C_1_16 * this.Xi[this.m9] - C_3_16 * this.Xr[this.m9];
        T3r = C_3_16 * this.Xr[this.m13] + C_1_16 * this.Xi[this.m13];
        T3i = C_3_16 * this.Xi[this.m13] - C_1_16 * this.Xr[this.m13];
        Rr = T1r + T3r;
        Ri = T1i + T3i;
        Sr = T3i - T1i;
        Si = T1r - T3r;
        this.Xr[this.m9] = this.Xr[this.m1] - Rr;
        this.Xi[this.m9] = this.Xi[this.m1] - Ri;
        this.Xr[this.m13] = this.Xr[this.m5] + Sr;
        this.Xi[this.m13] = this.Xi[this.m5] + Si;
        int n25 = this.m1;
        this.Xr[n25] = this.Xr[n25] + Rr;
        int n26 = this.m1;
        this.Xi[n26] = this.Xi[n26] + Ri;
        int n27 = this.m5;
        this.Xr[n27] = this.Xr[n27] - Sr;
        int n28 = this.m5;
        this.Xi[n28] = this.Xi[n28] - Si;
        T1r = SQRT2BY2 * (this.Xr[this.m10] + this.Xi[this.m10]);
        T1i = SQRT2BY2 * (this.Xi[this.m10] - this.Xr[this.m10]);
        T3r = SQRT2BY2 * (this.Xi[this.m14] - this.Xr[this.m14]);
        T3i = -SQRT2BY2 * (this.Xi[this.m14] + this.Xr[this.m14]);
        Rr = T1r + T3r;
        Ri = T1i + T3i;
        Sr = T3i - T1i;
        Si = T1r - T3r;
        this.Xr[this.m10] = this.Xr[this.m2] - Rr;
        this.Xi[this.m10] = this.Xi[this.m2] - Ri;
        this.Xr[this.m14] = this.Xr[this.m6] + Sr;
        this.Xi[this.m14] = this.Xi[this.m6] + Si;
        int n29 = this.m2;
        this.Xr[n29] = this.Xr[n29] + Rr;
        int n30 = this.m2;
        this.Xi[n30] = this.Xi[n30] + Ri;
        int n31 = this.m6;
        this.Xr[n31] = this.Xr[n31] - Sr;
        int n32 = this.m6;
        this.Xi[n32] = this.Xi[n32] - Si;
        T1r = C_3_16 * this.Xr[this.m11] + C_1_16 * this.Xi[this.m11];
        T1i = C_3_16 * this.Xi[this.m11] - C_1_16 * this.Xr[this.m11];
        T3r = -C_1_16 * this.Xr[this.m15] - C_3_16 * this.Xi[this.m15];
        T3i = -C_1_16 * this.Xi[this.m15] + C_3_16 * this.Xr[this.m15];
        Rr = T1r + T3r;
        Ri = T1i + T3i;
        Sr = T3i - T1i;
        Si = T1r - T3r;
        this.Xr[this.m11] = this.Xr[this.m3] - Rr;
        this.Xi[this.m11] = this.Xi[this.m3] - Ri;
        this.Xr[this.m15] = this.Xr[this.m7] + Sr;
        this.Xi[this.m15] = this.Xi[this.m7] + Si;
        int n33 = this.m3;
        this.Xr[n33] = this.Xr[n33] + Rr;
        int n34 = this.m3;
        this.Xi[n34] = this.Xi[n34] + Ri;
        int n35 = this.m7;
        this.Xr[n35] = this.Xr[n35] - Sr;
        int n36 = this.m7;
        this.Xi[n36] = this.Xi[n36] - Si;
    }
}

