/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.fft;

import com.oregondsp.signalProcessing.fft.CDFTsr16;
import com.oregondsp.signalProcessing.fft.CDFTsr8;

class CDFTsr {
    private static final float SQRT2BY2 = (float)(Math.sqrt(2.0) / 2.0);
    protected float[] xr;
    protected float[] xi;
    protected float[] Xr;
    protected float[] Xi;
    protected int xoffset;
    protected int xstride;
    protected int Xoffset;
    protected int m;
    protected int N;
    protected int N8;
    protected int N4;
    private CDFTsr dft1;
    private CDFTsr dft2;
    private CDFTsr dft3;
    private float[] c;
    private float[] c3;
    private float[] s;
    private float[] s3;
    private int f;
    private int reflect;

    CDFTsr(int m, float[] c, float[] c3, float[] s, float[] s3) {
        this.m = m;
        this.N = 1 << m;
        this.N8 = this.N / 8;
        this.N4 = this.N / 4;
        this.xoffset = 0;
        this.xstride = 1;
        this.Xoffset = 0;
        this.c = c;
        this.c3 = c3;
        this.s = s;
        this.s3 = s3;
        this.f = 1;
        this.reflect = 2 * c.length;
        if (m > 6) {
            this.dft1 = new CDFTsr(this, 0, 2, 0, m - 1);
            this.dft2 = new CDFTsr(this, 1, 4, this.N / 2, m - 2);
            this.dft3 = new CDFTsr(this, 3, 4, 3 * this.N / 4, m - 2);
        } else if (m == 6) {
            this.dft1 = new CDFTsr(this, 0, 2, 0, 5);
            this.dft2 = new CDFTsr16(1, 4, this.N / 2);
            this.dft3 = new CDFTsr16(3, 4, 3 * this.N / 4);
        } else if (m == 5) {
            this.dft1 = new CDFTsr16(0, 2, 0);
            this.dft2 = new CDFTsr8(1, 4, this.N / 2);
            this.dft3 = new CDFTsr8(3, 4, 3 * this.N / 4);
        }
    }

    protected CDFTsr() {
        this.dft1 = null;
        this.dft2 = null;
        this.dft3 = null;
    }

    protected CDFTsr(CDFTsr parent, int dataOffset, int dataStride, int transformOffset, int m) {
        this.c = parent.c;
        this.c3 = parent.c3;
        this.s = parent.s;
        this.s3 = parent.s3;
        this.m = m;
        this.N = 1 << m;
        this.N8 = this.N / 8;
        this.N4 = this.N / 4;
        this.xoffset = dataOffset;
        this.xstride = dataStride;
        this.Xoffset = transformOffset;
        this.f = this.c.length / this.N8;
        this.reflect = 2 * this.c.length;
        if (m > 6) {
            this.dft1 = new CDFTsr(this, dataOffset, dataStride * 2, transformOffset, m - 1);
            this.dft2 = new CDFTsr(this, dataOffset + dataStride, dataStride * 4, transformOffset + this.N / 2, m - 2);
            this.dft3 = new CDFTsr(this, dataOffset + 3 * dataStride, dataStride * 4, transformOffset + 3 * this.N / 4, m - 2);
        } else if (m == 6) {
            this.dft1 = new CDFTsr(this, dataOffset, dataStride * 2, transformOffset, 5);
            this.dft2 = new CDFTsr16(dataOffset + dataStride, dataStride * 4, transformOffset + this.N / 2);
            this.dft3 = new CDFTsr16(dataOffset + 3 * dataStride, dataStride * 4, transformOffset + 3 * this.N / 4);
        } else if (m == 5) {
            this.dft1 = new CDFTsr16(dataOffset, dataStride * 2, transformOffset);
            this.dft2 = new CDFTsr8(dataOffset + dataStride, dataStride * 4, transformOffset + this.N / 2);
            this.dft3 = new CDFTsr8(dataOffset + 3 * dataStride, dataStride * 4, transformOffset + 3 * this.N / 4);
        }
    }

    void link(float[] xr, float[] xi, float[] Xr, float[] Xi) {
        this.xr = xr;
        this.xi = xi;
        this.Xr = Xr;
        this.Xi = Xi;
        this.dft1.link(xr, xi, Xr, Xi);
        this.dft2.link(xr, xi, Xr, Xi);
        this.dft3.link(xr, xi, Xr, Xi);
    }

    void evaluate() {
        float T3i;
        float T3r;
        float T1i;
        float T1r;
        float Wi;
        float Wr;
        int fk;
        int k;
        this.dft1.evaluate();
        this.dft2.evaluate();
        this.dft3.evaluate();
        int kp = this.Xoffset;
        int kpN4 = kp + this.N4;
        int kpN2 = kpN4 + this.N4;
        int kp3N4 = kpN2 + this.N4;
        float Rr = this.Xr[kpN2] + this.Xr[kp3N4];
        float Ri = this.Xi[kpN2] + this.Xi[kp3N4];
        float Sr = this.Xi[kp3N4] - this.Xi[kpN2];
        float Si = this.Xr[kpN2] - this.Xr[kp3N4];
        this.Xr[kpN2] = this.Xr[kp] - Rr;
        this.Xi[kpN2] = this.Xi[kp] - Ri;
        this.Xr[kp3N4] = this.Xr[kpN4] + Sr;
        this.Xi[kp3N4] = this.Xi[kpN4] + Si;
        int n = kp;
        this.Xr[n] = this.Xr[n] + Rr;
        int n2 = kp;
        this.Xi[n2] = this.Xi[n2] + Ri;
        int n3 = kpN4;
        this.Xr[n3] = this.Xr[n3] - Sr;
        int n4 = kpN4;
        this.Xi[n4] = this.Xi[n4] - Si;
        for (k = 1; k < this.N8; ++k) {
            fk = this.f * k;
            kp = k + this.Xoffset;
            kpN4 = kp + this.N4;
            kpN2 = kpN4 + this.N4;
            kp3N4 = kpN2 + this.N4;
            Wr = this.c[fk];
            Wi = this.s[fk];
            T1r = Wr * this.Xr[kpN2] - Wi * this.Xi[kpN2];
            T1i = Wr * this.Xi[kpN2] + Wi * this.Xr[kpN2];
            Wr = this.c3[fk];
            Wi = this.s3[fk];
            T3r = Wr * this.Xr[kp3N4] - Wi * this.Xi[kp3N4];
            T3i = Wr * this.Xi[kp3N4] + Wi * this.Xr[kp3N4];
            Rr = T1r + T3r;
            Ri = T1i + T3i;
            Sr = T3i - T1i;
            Si = T1r - T3r;
            this.Xr[kpN2] = this.Xr[kp] - Rr;
            this.Xi[kpN2] = this.Xi[kp] - Ri;
            this.Xr[kp3N4] = this.Xr[kpN4] + Sr;
            this.Xi[kp3N4] = this.Xi[kpN4] + Si;
            int n5 = kp;
            this.Xr[n5] = this.Xr[n5] + Rr;
            int n6 = kp;
            this.Xi[n6] = this.Xi[n6] + Ri;
            int n7 = kpN4;
            this.Xr[n7] = this.Xr[n7] - Sr;
            int n8 = kpN4;
            this.Xi[n8] = this.Xi[n8] - Si;
        }
        kp = this.N8 + this.Xoffset;
        kpN4 = kp + this.N4;
        kpN2 = kpN4 + this.N4;
        kp3N4 = kpN2 + this.N4;
        T1r = SQRT2BY2 * (this.Xr[kpN2] + this.Xi[kpN2]);
        T1i = SQRT2BY2 * (this.Xi[kpN2] - this.Xr[kpN2]);
        T3r = SQRT2BY2 * (this.Xi[kp3N4] - this.Xr[kp3N4]);
        T3i = -SQRT2BY2 * (this.Xi[kp3N4] + this.Xr[kp3N4]);
        Rr = T1r + T3r;
        Ri = T1i + T3i;
        Sr = T3i - T1i;
        Si = T1r - T3r;
        this.Xr[kpN2] = this.Xr[kp] - Rr;
        this.Xi[kpN2] = this.Xi[kp] - Ri;
        this.Xr[kp3N4] = this.Xr[kpN4] + Sr;
        this.Xi[kp3N4] = this.Xi[kpN4] + Si;
        int n9 = kp;
        this.Xr[n9] = this.Xr[n9] + Rr;
        int n10 = kp;
        this.Xi[n10] = this.Xi[n10] + Ri;
        int n11 = kpN4;
        this.Xr[n11] = this.Xr[n11] - Sr;
        int n12 = kpN4;
        this.Xi[n12] = this.Xi[n12] - Si;
        for (k = this.N8 + 1; k < this.N4; ++k) {
            fk = this.reflect - this.f * k;
            kp = k + this.Xoffset;
            kpN4 = kp + this.N4;
            kpN2 = kpN4 + this.N4;
            kp3N4 = kpN2 + this.N4;
            Wr = -this.s[fk];
            Wi = -this.c[fk];
            T1r = Wr * this.Xr[kpN2] - Wi * this.Xi[kpN2];
            T1i = Wr * this.Xi[kpN2] + Wi * this.Xr[kpN2];
            Wr = this.s3[fk];
            Wi = this.c3[fk];
            T3r = Wr * this.Xr[kp3N4] - Wi * this.Xi[kp3N4];
            T3i = Wr * this.Xi[kp3N4] + Wi * this.Xr[kp3N4];
            Rr = T1r + T3r;
            Ri = T1i + T3i;
            Sr = T3i - T1i;
            Si = T1r - T3r;
            this.Xr[kpN2] = this.Xr[kp] - Rr;
            this.Xi[kpN2] = this.Xi[kp] - Ri;
            this.Xr[kp3N4] = this.Xr[kpN4] + Sr;
            this.Xi[kp3N4] = this.Xi[kpN4] + Si;
            int n13 = kp;
            this.Xr[n13] = this.Xr[n13] + Rr;
            int n14 = kp;
            this.Xi[n14] = this.Xi[n14] + Ri;
            int n15 = kpN4;
            this.Xr[n15] = this.Xr[n15] - Sr;
            int n16 = kpN4;
            this.Xi[n16] = this.Xi[n16] - Si;
        }
    }
}

