/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.fft;

import com.oregondsp.signalProcessing.fft.CDFTsr;
import com.oregondsp.signalProcessing.fft.CDFTsr16;
import com.oregondsp.signalProcessing.fft.CDFTsr8;

public class CDFT {
    private float[] yr;
    private float[] yi;
    private boolean arraysUnlinked;
    private float[] c;
    private float[] c3;
    private float[] s;
    private float[] s3;
    int N;
    int log2N;
    private CDFTsr dft;

    public CDFT() {
    }

    public CDFT(int log2N) {
        if (log2N < 3) {
            throw new IllegalArgumentException("DFT size must be >= 8");
        }
        this.arraysUnlinked = true;
        this.log2N = log2N;
        this.N = 1 << log2N;
        this.createTable();
        if (log2N == 3) {
            this.dft = new CDFTsr8(0, 1, 0);
        } else if (log2N == 4) {
            this.dft = new CDFTsr16(0, 1, 0);
        } else if (log2N >= 5) {
            this.dft = new CDFTsr(log2N, this.c, this.c3, this.s, this.s3);
        }
    }

    public void evaluate(float[] xr, float[] xi, float[] Xr, float[] Xi) {
        this.yr = Xr;
        this.yi = Xi;
        this.dft.link(xr, xi, Xr, Xi);
        this.arraysUnlinked = false;
        this.dft.evaluate();
    }

    public void evaluateInverse(float[] Xr, float[] Xi, float[] xr, float[] xi) {
        this.yr = xr;
        this.yi = xi;
        this.dft.link(Xr, Xi, xr, xi);
        this.arraysUnlinked = false;
        this.evaluateInverse();
    }

    public CDFT(float[] xr, float[] xi, float[] yr, float[] yi, int log2N) {
        if (log2N < 3) {
            throw new IllegalArgumentException("DFT size must be >= 8");
        }
        this.yr = yr;
        this.yi = yi;
        this.log2N = log2N;
        this.N = 1 << log2N;
        this.createTable();
        if (log2N == 3) {
            this.dft = new CDFTsr8(0, 1, 0);
        } else if (log2N == 4) {
            this.dft = new CDFTsr16(0, 1, 0);
        } else if (log2N >= 5) {
            this.dft = new CDFTsr(log2N, this.c, this.c3, this.s, this.s3);
        }
        this.dft.link(xr, xi, yr, yi);
        this.arraysUnlinked = false;
    }

    public void evaluate() {
        if (this.arraysUnlinked) {
            throw new IllegalStateException("Sequence and transform arrays are not linked");
        }
        this.dft.evaluate();
    }

    public void evaluateInverse() {
        if (this.arraysUnlinked) {
            throw new IllegalStateException("Sequence and transform arrays are not linked");
        }
        this.dft.evaluate();
        float scale = 1.0f / (float)this.N;
        int N2 = this.N / 2;
        this.yr[0] = this.yr[0] * scale;
        this.yi[0] = this.yi[0] * scale;
        int n = N2;
        this.yr[n] = this.yr[n] * scale;
        int n2 = N2;
        this.yi[n2] = this.yi[n2] * scale;
        int i = 1;
        for (int j = this.N - 1; i < j; ++i, --j) {
            float tmp = this.yr[i];
            this.yr[i] = this.yr[j] * scale;
            this.yr[j] = tmp * scale;
            tmp = this.yi[i];
            this.yi[i] = this.yi[j] * scale;
            this.yi[j] = tmp * scale;
        }
    }

    private void createTable() {
        int N8 = this.N / 8;
        this.c = new float[N8];
        this.c3 = new float[N8];
        this.s = new float[N8];
        this.s3 = new float[N8];
        for (int i = 0; i < N8; ++i) {
            this.c[i] = (float)Math.cos(Math.PI * 2 * (double)i / (double)this.N);
            this.c3[i] = (float)Math.cos(Math.PI * 6 * (double)i / (double)this.N);
            this.s[i] = -((float)Math.sin(Math.PI * 2 * (double)i / (double)this.N));
            this.s3[i] = -((float)Math.sin(Math.PI * 6 * (double)i / (double)this.N));
        }
    }

    public static void dftProduct(float[] Xr, float[] Xi, float[] Yr, float[] Yi, float sign) {
        if (Xr.length != Yr.length || Xi.length != Yi.length || Xr.length != Xi.length) {
            throw new IllegalArgumentException("Transform array lengths are not equal");
        }
        for (int i = 0; i < Xr.length; ++i) {
            float tmp = Xr[i] * Yr[i] - sign * Xi[i] * Yi[i];
            Yi[i] = Xr[i] * Yi[i] + sign * Xi[i] * Yr[i];
            Yr[i] = tmp;
        }
    }
}

