/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing;

public class Window {
    protected float[] w;

    public Window(float[] w) {
        this.w = (float[])w.clone();
    }

    public Window(int N) {
        this.w = new float[N];
    }

    public int length() {
        return this.w.length;
    }

    public void timesEquals(float[] x) {
        if (x.length != this.w.length) {
            throw new IllegalArgumentException("Argument length does not match window length");
        }
        for (int i = 0; i < this.w.length; ++i) {
            int n = i;
            this.w[n] = this.w[n] * x[i];
        }
    }

    public float[] getArray() {
        return (float[])this.w.clone();
    }

    public void window(float[] x, int index, float[] y) {
        if (y.length != this.w.length) {
            throw new IllegalArgumentException("Destination array length does not match window length");
        }
        for (int i = 0; i < this.w.length; ++i) {
            int j = index + i;
            y[i] = j >= 0 && j < x.length ? this.w[i] * x[j] : 0.0f;
        }
    }
}

