/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing;

import java.util.Arrays;

public class Sequence {
    protected float[] x;

    public Sequence(float[] x) {
        this.x = new float[x.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
    }

    public Sequence(int N) {
        this.x = new float[N];
    }

    public static void alias(float[] src, float[] dst) {
        int slength = src.length;
        int dlength = dst.length;
        Arrays.fill(dst, 0.0f);
        for (int i = 0; i < slength; ++i) {
            int n = i % dlength;
            dst[n] = dst[n] + src[i];
        }
    }

    public void alias(int N) {
        float[] newx = new float[N];
        Sequence.alias(this.x, newx);
        this.x = newx;
    }

    public float get(int index) {
        float retval = 0.0f;
        if (index >= 0 && index < this.x.length) {
            retval = this.x[index];
        }
        return retval;
    }

    public float[] getArray() {
        return this.x;
    }

    public static void reverse(float[] y) {
        int i = 0;
        for (int j = y.length - 1; i < j; ++i, --j) {
            float tmp = y[i];
            y[i] = y[j];
            y[j] = tmp;
        }
    }

    public void reverse() {
        Sequence.reverse(this.x);
    }

    public static void rmean(float[] y) {
        int i;
        float mean = 0.0f;
        for (i = 0; i < y.length; ++i) {
            mean += y[i];
        }
        mean /= (float)y.length;
        i = 0;
        while (i < y.length) {
            int n = i++;
            y[n] = y[n] - mean;
        }
    }

    public void rmean() {
        Sequence.rmean(this.x);
    }

    public static void circularShift(float[] y, int shift) {
        int i;
        int N = y.length;
        int s = shift % N;
        if (s > 0 && N - s < s) {
            s -= N;
        } else if (s < 0 && N + s < -s) {
            s += N;
        }
        float[] tmp = new float[Math.abs(s)];
        if (s > 0) {
            for (i = 0; i < s; ++i) {
                tmp[i] = y[N - s + i];
            }
            for (i = N - 1 - s; i >= 0; --i) {
                y[i + s] = y[i];
            }
            for (i = 0; i < s; ++i) {
                y[i] = tmp[i];
            }
        }
        if (s < 0) {
            for (i = 0; i < -s; ++i) {
                tmp[i] = y[i];
            }
            for (i = -s; i < N; ++i) {
                y[i + s] = y[i];
            }
            for (i = 0; i < -s; ++i) {
                y[N + s + i] = tmp[i];
            }
        }
    }

    public void circularShift(int shift) {
        Sequence.circularShift(this.x, shift);
    }

    public static void zeroShift(float[] y, int shift) {
        block5: {
            int i;
            block6: {
                int i2;
                block4: {
                    if (Math.abs(shift) < y.length) break block4;
                    Arrays.fill(y, 0.0f);
                    break block5;
                }
                if (shift <= 0) break block6;
                for (i2 = y.length - 1; i2 >= shift; --i2) {
                    y[i2] = y[i2 - shift];
                }
                for (i2 = 0; i2 < shift; ++i2) {
                    y[i2] = 0.0f;
                }
                break block5;
            }
            if (shift >= 0) break block5;
            for (i = 0; i < y.length + shift; ++i) {
                y[i] = y[i - shift];
            }
            for (i = y.length + shift; i < y.length; ++i) {
                y[i] = 0.0f;
            }
        }
    }

    public void zeroShift(int shift) {
        Sequence.zeroShift(this.x, shift);
    }

    public static void decimate(float[] y, int decrate, float[] ydecimated) {
        int n = Math.min(ydecimated.length, y.length / decrate);
        for (int i = 0; i < n; ++i) {
            ydecimated[i] = y[i * decrate];
        }
    }

    public void decimate(int decrate) {
        float[] tmp = new float[this.x.length / decrate];
        Sequence.decimate(this.x, decrate, tmp);
        this.x = tmp;
    }

    public static void stretch(float[] y, int rate, float[] ystretched) {
        int n = Math.min(y.length, ystretched.length / rate);
        Arrays.fill(ystretched, 0.0f);
        for (int i = 0; i < n; ++i) {
            ystretched[i * rate] = y[i];
        }
    }

    public void stretch(int rate) {
        float[] tmp = new float[this.x.length * rate];
        Sequence.stretch(this.x, rate, tmp);
        this.x = tmp;
    }

    public static void timesEquals(float[] y, float f) {
        int i = 0;
        while (i < y.length) {
            int n = i++;
            y[n] = y[n] * f;
        }
    }

    public void timesEquals(float f) {
        Sequence.timesEquals(this.x, f);
    }

    public static void pad(float[] y, float[] ypadded) {
        if (y.length < ypadded.length) {
            Arrays.fill(ypadded, 0.0f);
            System.arraycopy(y, 0, ypadded, 0, y.length);
        } else {
            System.arraycopy(y, 0, ypadded, 0, ypadded.length);
        }
    }

    public void pad(int n) {
        if (n > this.x.length) {
            float[] tmp = new float[n];
            Sequence.pad(this.x, tmp);
            this.x = tmp;
        }
    }
}

