/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed3;

import edu.sc.seis.seisFile.mseed3.FDSNSourceIdException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FDSNSourceId {
    public static final String FDSN_PREFIX = "FDSN:";
    public static final String SEP = "_";
    public static final String sourceIdRegExString = "FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})_([A-Z0-9-]{0,8})_([A-Z])_([A-Z0-9]+)_([A-Z0-9]+)";
    public static final Pattern sourceIdRegEx = Pattern.compile("FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})_([A-Z0-9-]{0,8})_([A-Z])_([A-Z0-9]+)_([A-Z0-9]+)");
    public static final String DEFAULT_SOURCE_CODE = "H";
    public static final String DEFAULT_NETWORK_CODE = "XX";
    public static final String DEFAULT_STATION_CODE = "ABC";
    public static final String DEFAULT_LOCATION_CODE = "";
    public static final String DEFAULT_SUBSOURCE_CODE = "U";
    protected String networkCode;
    protected String stationCode;
    protected String locationCode;
    protected String bandCode;
    protected String sourceCode;
    protected String subsourceCode;

    public FDSNSourceId(String networkCode, String stationCode, String locationCode, String bandCode, String sourceCode, String subsourceCode) {
        this.networkCode = networkCode;
        this.stationCode = stationCode;
        this.locationCode = locationCode;
        this.bandCode = bandCode;
        this.sourceCode = sourceCode;
        this.subsourceCode = subsourceCode;
    }

    public static FDSNSourceId parse(String sourceIdUrl) throws FDSNSourceIdException {
        Matcher m = sourceIdRegEx.matcher(sourceIdUrl);
        if (m.matches()) {
            return new FDSNSourceId(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6));
        }
        throw new FDSNSourceIdException("Parse error, does not match regular expression: " + sourceIdUrl + "  FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})_([A-Z0-9-]{0,8})_([A-Z])_([A-Z0-9]+)_([A-Z0-9]+)");
    }

    public static FDSNSourceId fromNSLC(String networkCode, String stationCode, String locationCode, String channelCode) throws FDSNSourceIdException {
        String band = DEFAULT_LOCATION_CODE;
        String source = DEFAULT_LOCATION_CODE;
        String subsource = DEFAULT_LOCATION_CODE;
        if (channelCode.length() == 0) {
            throw new FDSNSourceIdException("Channel code is empty");
        }
        if (channelCode.length() <= 3) {
            band = channelCode.substring(0, 1);
            if (channelCode.length() > 1) {
                source = channelCode.substring(1, 2);
                if (channelCode.length() > 2) {
                    subsource = channelCode.substring(2, 3);
                }
            }
        } else if (channelCode.contains(SEP)) {
            String[] bss = channelCode.split(SEP, 3);
            band = bss[0];
            source = bss[1];
            if (bss.length > 2) {
                subsource = bss[2];
            }
        } else {
            throw new FDSNSourceIdException("Unable to parse channel code into band, source, subsource: " + channelCode);
        }
        return new FDSNSourceId(networkCode.trim(), stationCode.trim(), locationCode.trim(), band.trim(), source.trim(), subsource.trim());
    }

    public static FDSNSourceId createUnknown(double sampleRate) throws FDSNSourceIdException {
        String bandCode = FDSNSourceId.bandCodeForRate(sampleRate, 0.01);
        return new FDSNSourceId(DEFAULT_NETWORK_CODE, DEFAULT_STATION_CODE, DEFAULT_LOCATION_CODE, bandCode, DEFAULT_SOURCE_CODE, DEFAULT_SUBSOURCE_CODE);
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public String getLocationCode() {
        return this.locationCode;
    }

    public String getBandCode() {
        return this.bandCode;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public String getSubsourceCode() {
        return this.subsourceCode;
    }

    public String getChannelCode() {
        if (this.bandCode.length() == 1 && this.sourceCode.length() == 1 && this.subsourceCode.length() == 1) {
            return this.bandCode + this.sourceCode + this.subsourceCode;
        }
        return this.bandCode + SEP + this.sourceCode + SEP + this.subsourceCode;
    }

    public String toString() {
        return FDSN_PREFIX + this.networkCode + SEP + this.stationCode + SEP + this.locationCode + SEP + this.bandCode + SEP + this.sourceCode + SEP + this.subsourceCode;
    }

    public static String bandCodeForRate(Double sampRate, Double response_lb) throws FDSNSourceIdException {
        if (sampRate == null || sampRate == 0.0) {
            return "I";
        }
        if (sampRate < 0.0) {
            sampRate = -1.0 / sampRate;
        }
        if (response_lb < 0.0) {
            response_lb = -1.0 / response_lb;
        }
        if (sampRate >= 5000.0) {
            return "J";
        }
        if (1000.0 <= sampRate && sampRate < 5000.0) {
            if (response_lb != null && response_lb < 0.1) {
                return "F";
            }
            return "G";
        }
        if (250.0 <= sampRate && sampRate < 1000.0) {
            if (response_lb != null && response_lb < 0.1) {
                return "C";
            }
            return "D";
        }
        if (80.0 <= sampRate && sampRate < 250.0) {
            if (response_lb != null && response_lb < 0.1) {
                return DEFAULT_SOURCE_CODE;
            }
            return "E";
        }
        if (10.0 <= sampRate && sampRate < 80.0) {
            if (response_lb != null && response_lb < 0.1) {
                return "B";
            }
            return "S";
        }
        if (1.0 < sampRate && sampRate < 10.0) {
            return "M";
        }
        if (0.5 < sampRate && sampRate < 1.5) {
            return "L";
        }
        if (0.1 <= sampRate && sampRate < 1.0) {
            return "V";
        }
        if (0.01 <= sampRate && sampRate < 0.1) {
            return DEFAULT_SUBSOURCE_CODE;
        }
        if (0.001 <= sampRate && sampRate < 0.01) {
            return "W";
        }
        if (1.0E-4 <= sampRate && sampRate < 0.001) {
            return "R";
        }
        if (1.0E-5 <= sampRate && sampRate < 1.0E-4) {
            return "P";
        }
        if (1.0E-6 <= sampRate && sampRate < 1.0E-5) {
            return "T";
        }
        if (sampRate < 1.0E-6) {
            return "Q";
        }
        throw new FDSNSourceIdException("Unable to calc band code for: " + sampRate + " " + response_lb);
    }
}

