/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Blockette200
extends DataBlockette {
    private static final int SIGNAL = 4;
    private static final int PERIOD = 8;
    private static final int BACKGROUND = 12;
    private static final int SIGNAL_ONSET = 18;
    private static final int EVENT_DETECTOR = 28;
    private static final int B200_SIZE = 52;
    private static final int EVENT_DETECTOR_LENGTH = 24;

    public Blockette200(float signal, float period, float background, Btime signalOnset, String eventDetector) {
        super(52);
        byte[] detectorBytes;
        Utility.insertFloat(signal, this.info, 4);
        Utility.insertFloat(period, this.info, 8);
        Utility.insertFloat(background, this.info, 12);
        byte[] onsetBytes = signalOnset.getAsBytes();
        System.arraycopy(onsetBytes, 0, this.info, 18, onsetBytes.length);
        if (eventDetector.length() > 24) {
            throw new IllegalArgumentException("The event detector can only be up to 24 characters in length");
        }
        try {
            detectorBytes = eventDetector.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Java was unable to find the US-ASCII character encoding.");
        }
        if (detectorBytes.length != eventDetector.length()) {
            throw new IllegalArgumentException("The characters in event detector must be in the ASCII character set i.e. from 0-127");
        }
        detectorBytes = Utility.pad(detectorBytes, 24, (byte)32);
        System.arraycopy(detectorBytes, 0, this.info, 28, detectorBytes.length);
    }

    public Blockette200(byte[] info, boolean swapBytes) throws SeedFormatException {
        super(info, swapBytes);
        this.trimToSize(this.getSize());
    }

    @Override
    public String getName() {
        return "Generic Event Detection Blockette";
    }

    @Override
    public int getSize() {
        return 52;
    }

    @Override
    public int getType() {
        return 200;
    }

    public float getSignal() {
        return Float.intBitsToFloat(Utility.bytesToInt(this.info, 4, this.swapBytes));
    }

    public float getPeriod() {
        return Float.intBitsToFloat(Utility.bytesToInt(this.info, 8, this.swapBytes));
    }

    public float getBackground() {
        return Float.intBitsToFloat(Utility.bytesToInt(this.info, 12, this.swapBytes));
    }

    public Btime getSignalOnset() {
        return new Btime(this.info, 18);
    }

    public String getEventDetector() {
        return new String(this.info, 28, 24);
    }

    @Override
    public void writeASCII(PrintWriter out) {
        out.println("Blockette200 sig=" + this.getSignal() + " per=" + this.getPeriod() + " bkgrd=" + this.getBackground());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Blockette200) {
            byte[] oinfo = ((Blockette200)o).info;
            if (this.info.length != oinfo.length) {
                return false;
            }
            for (int i = 0; i < oinfo.length; ++i) {
                if (this.info[i] == oinfo[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

