/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.virtualnet;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.virtualnet.ContributorDataCenter;
import edu.sc.seis.seisFile.fdsnws.virtualnet.VirtualNetwork;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class VirtualNetworkList {
    String source;
    String sender;
    String module;
    String sentDate;
    List<VirtualNetwork> virtualNetworks = new ArrayList<VirtualNetwork>();
    List<ContributorDataCenter> dataCenters = new ArrayList<ContributorDataCenter>();

    private VirtualNetworkList() {
    }

    public VirtualNetworkList(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("VirtualNetworks", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("source")) {
                    this.source = StaxUtil.pullText(reader, "source");
                    continue;
                }
                if (elName.equals("sender")) {
                    this.sender = StaxUtil.pullText(reader, "sender");
                    continue;
                }
                if (elName.equals("module")) {
                    this.module = StaxUtil.pullText(reader, "module");
                    continue;
                }
                if (elName.equals("sentDate")) {
                    this.sentDate = StaxUtil.pullText(reader, "sentDate");
                    continue;
                }
                if (elName.equals("dataCenter")) {
                    this.dataCenters.add(new ContributorDataCenter(reader));
                    continue;
                }
                if (elName.equals("virtualNetwork")) {
                    this.virtualNetworks.add(new VirtualNetwork(reader));
                    break;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getSender() {
        return this.sender;
    }

    public String getModule() {
        return this.module;
    }

    public String getSentDate() {
        return this.sentDate;
    }

    public List<ContributorDataCenter> getDataCenters() {
        return this.dataCenters;
    }

    public List<VirtualNetwork> getVirtualNetworks() {
        return this.virtualNetworks;
    }

    public static VirtualNetworkList createEmptyVirtualNets() {
        return new VirtualNetworkList();
    }
}

