/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseFilterType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Pole;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import edu.sc.seis.seisFile.fdsnws.stationxml.Zero;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PolesZeros
extends BaseFilterType {
    private String pzTransferType;
    private float normalizationFactor;
    private float normalizationFreq;
    private List<Pole> poleList = new ArrayList<Pole>();
    private List<Zero> zeroList = new ArrayList<Zero>();
    public static final String DIGITAL = "DIGITAL (Z-TRANSFORM)";
    public static final String LAPLACE_HERTZ = "LAPLACE (HERTZ)";
    public static final String LAPLACE_RAD_PER_SEC = "LAPLACE (RADIANS/SECOND)";

    public PolesZeros(String resourceId, String name, String description, Unit inputUnits, Unit outputUnits, String pzTransferType, float normalizationFactor, float normalizationFreq, List<Zero> zeroList, List<Pole> poleList) {
        super(resourceId, name, description, inputUnits, outputUnits);
        this.pzTransferType = pzTransferType;
        this.normalizationFactor = normalizationFactor;
        this.normalizationFreq = normalizationFreq;
        this.zeroList = zeroList;
        this.poleList = poleList;
    }

    public PolesZeros(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("PolesZeros", reader);
        super.parseAttributes(startE);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("PzTransferFunctionType")) {
                    this.pzTransferType = StaxUtil.pullText(reader, "PzTransferFunctionType");
                    continue;
                }
                if (elName.equals("NormalizationFactor")) {
                    this.normalizationFactor = StaxUtil.pullFloat(reader, "NormalizationFactor");
                    continue;
                }
                if (elName.equals("NormalizationFrequency")) {
                    this.normalizationFreq = StaxUtil.pullFloat(reader, "NormalizationFrequency");
                    continue;
                }
                if (elName.equals("Pole")) {
                    this.poleList.add(new Pole(reader));
                    continue;
                }
                if (elName.equals("Zero")) {
                    this.zeroList.add(new Zero(reader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getPzTransferType() {
        return this.pzTransferType;
    }

    public float getNormalizationFactor() {
        return this.normalizationFactor;
    }

    public float getNormalizationFreq() {
        return this.normalizationFreq;
    }

    public List<Pole> getPoleList() {
        return this.poleList;
    }

    public List<Zero> getZeroList() {
        return this.zeroList;
    }
}

