/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class RealQuantity {
    Float value;
    Float confidenceLevel;
    Float uncertainty;

    public RealQuantity(float value) {
        this.value = Float.valueOf(value);
    }

    public RealQuantity(XMLEventReader reader, String tagName) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("value")) {
                    this.value = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "value")));
                    continue;
                }
                if (elName.equals("uncertainty")) {
                    this.uncertainty = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "uncertainty")));
                    continue;
                }
                if (elName.equals("confidenceLevel")) {
                    this.confidenceLevel = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "confidenceLevel")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public Float getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public Float getUncertainty() {
        return this.uncertainty;
    }

    public Float getValue() {
        return this.value;
    }

    public void setConfidenceLevel(Float confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public void setUncertainty(Float uncertainty) {
        this.uncertainty = uncertainty;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public String toString() {
        return "" + this.value;
    }
}

