/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Arrival;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.OriginQuality;
import edu.sc.seis.seisFile.fdsnws.quakeml.OriginUncertainty;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.Time;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Origin {
    public static final String ELEMENT_NAME = "origin";
    Time time;
    RealQuantity latitude;
    RealQuantity longitude;
    RealQuantity depth = new RealQuantity(0.0f);
    String depthType;
    boolean timeFixed = false;
    boolean epicenterFixed = false;
    String earthModelID;
    List<Comment> commentList = new ArrayList<Comment>();
    List<Arrival> arrivalList = new ArrayList<Arrival>();
    String waveformID;
    OriginQuality quality;
    OriginUncertainty originUncertainty;
    String evaluationMode;
    String evaluationStatus;
    String type;
    CreationInfo creationInfo;
    String methodID;
    String referenceSystemID;
    String region;
    String publicId;
    String irisContributor = "";
    String irisCatalog = "";
    private Integer dbid;

    public Origin() {
        this.publicId = "autogen" + Long.toHexString(Double.doubleToLongBits(Math.random()));
    }

    public Origin(Instant originTime, float lat, float lon) {
        this.time = new Time(originTime);
        this.latitude = new RealQuantity(lat);
        this.longitude = new RealQuantity(lon);
    }

    public Origin(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        Attribute contributorAttr;
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        Attribute catalogAttr = startE.getAttributeByName(new QName("http://service.iris.edu/fdsnws/event/1/", "catalog"));
        if (catalogAttr != null) {
            this.irisCatalog = catalogAttr.getValue();
        }
        if ((contributorAttr = startE.getAttributeByName(new QName("http://service.iris.edu/fdsnws/event/1/", "contributor"))) != null) {
            this.irisContributor = contributorAttr.getValue();
        }
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("waveformID")) {
                    this.waveformID = StaxUtil.pullText(reader, "waveformID");
                    continue;
                }
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                if (elName.equals("time")) {
                    this.time = new Time(reader, "time");
                    continue;
                }
                if (elName.equals("latitude")) {
                    this.latitude = new RealQuantity(reader, "latitude");
                    continue;
                }
                if (elName.equals("longitude")) {
                    this.longitude = new RealQuantity(reader, "longitude");
                    continue;
                }
                if (elName.equals("depth")) {
                    this.depth = new RealQuantity(reader, "depth");
                    continue;
                }
                if (elName.equals("depthType")) {
                    this.depthType = StaxUtil.pullText(reader, "depthType");
                    continue;
                }
                if (elName.equals("timeFixed")) {
                    this.timeFixed = Boolean.parseBoolean(StaxUtil.pullText(reader, "timeFixed"));
                    continue;
                }
                if (elName.equals("epicenterFixed")) {
                    this.epicenterFixed = Boolean.parseBoolean(StaxUtil.pullText(reader, "epicenterFixed"));
                    continue;
                }
                if (elName.equals("earthModelID")) {
                    this.earthModelID = StaxUtil.pullText(reader, "earthModelID");
                    continue;
                }
                if (elName.equals("quality")) {
                    this.quality = new OriginQuality(reader);
                    continue;
                }
                if (elName.equals("originUncertainty")) {
                    this.originUncertainty = new OriginUncertainty(reader);
                    continue;
                }
                if (elName.equals("methodID")) {
                    this.methodID = StaxUtil.pullText(reader, "methodID");
                    continue;
                }
                if (elName.equals("referenceSystemID")) {
                    this.referenceSystemID = StaxUtil.pullText(reader, "referenceSystemID");
                    continue;
                }
                if (elName.equals("region")) {
                    this.region = StaxUtil.pullText(reader, "region");
                    continue;
                }
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                if (elName.equals("evaluationMode")) {
                    this.evaluationMode = StaxUtil.pullText(reader, "evaluationMode");
                    continue;
                }
                if (elName.equals("evaluationStatus")) {
                    this.evaluationStatus = StaxUtil.pullText(reader, "evaluationStatus");
                    continue;
                }
                if (elName.equals("arrival")) {
                    this.arrivalList.add(new Arrival(reader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            reader.nextEvent();
        }
    }

    public List<Arrival> getArrivalList() {
        return this.arrivalList;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public Integer getDbid() {
        return this.dbid;
    }

    public RealQuantity getDepth() {
        return this.depth;
    }

    public String getDepthType() {
        return this.depthType;
    }

    public String getEarthModelID() {
        return this.earthModelID;
    }

    public String getEvaluationMode() {
        return this.evaluationMode;
    }

    public String getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public String getIrisCatalog() {
        return this.irisCatalog;
    }

    public String getIrisContributor() {
        return this.irisContributor;
    }

    public RealQuantity getLatitude() {
        return this.latitude;
    }

    public RealQuantity getLongitude() {
        return this.longitude;
    }

    public Location asLocation() {
        return new Location(this.getLatitude().getValue().floatValue(), this.getLongitude().getValue().floatValue(), this.getDepth().getValue().floatValue());
    }

    public String getMethodID() {
        return this.methodID;
    }

    public OriginUncertainty getOriginUncertainty() {
        return this.originUncertainty;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public OriginQuality getQuality() {
        return this.quality;
    }

    public String getReferenceSystemID() {
        return this.referenceSystemID;
    }

    public String getRegion() {
        return this.region;
    }

    public Time getTime() {
        return this.time;
    }

    public String getType() {
        return this.type;
    }

    public String getWaveformID() {
        return this.waveformID;
    }

    public boolean isEpicenterFixed() {
        return this.epicenterFixed;
    }

    public boolean isTimeFixed() {
        return this.timeFixed;
    }

    public void setArrivalList(List<Arrival> arrivalList) {
        this.arrivalList = arrivalList;
    }

    public void setCommentList(List<Comment> commentList) {
        this.commentList = commentList;
    }

    public void setCreationInfo(CreationInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setDbid(Integer dbid) {
        this.dbid = dbid;
    }

    public void setDepth(RealQuantity depth) {
        this.depth = depth;
    }

    public void setDepthType(String depthType) {
        this.depthType = depthType;
    }

    public void setEarthModelID(String earthModelID) {
        this.earthModelID = earthModelID;
    }

    public void setEpicenterFixed(boolean epicenterFixed) {
        this.epicenterFixed = epicenterFixed;
    }

    public void setEvaluationMode(String evaluationMode) {
        this.evaluationMode = evaluationMode;
    }

    public void setEvaluationStatus(String evaluationStatus) {
        this.evaluationStatus = evaluationStatus;
    }

    public void setIrisCatalog(String irisCatalog) {
        this.irisCatalog = irisCatalog;
    }

    public void setIrisContributor(String irisContributor) {
        this.irisContributor = irisContributor;
    }

    public void setLatitude(RealQuantity latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(RealQuantity longitude) {
        this.longitude = longitude;
    }

    public void setMethodID(String methodID) {
        this.methodID = methodID;
    }

    public void setOriginUncertainty(OriginUncertainty originUncertainty) {
        this.originUncertainty = originUncertainty;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setQuality(OriginQuality quality) {
        this.quality = quality;
    }

    public void setReferenceSystemID(String referenceSystemID) {
        this.referenceSystemID = referenceSystemID;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public void setTimeFixed(boolean timeFixed) {
        this.timeFixed = timeFixed;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setWaveformID(String waveformID) {
        this.waveformID = waveformID;
    }

    public String toString() {
        return this.time.getValue() + " (" + this.latitude.getValue() + ", " + this.longitude.getValue() + ") " + this.depth.getValue();
    }
}

