/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.TimeQueryLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stax.StAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractFDSNQuerier
implements AutoCloseable {
    static XMLValidationSchemaFactory sfactory;
    static HashMap<URL, XMLValidationSchema> schemaCache;
    public static final String DEFAULT_USER_AGENT;
    String userAgent = DEFAULT_USER_AGENT;
    String acceptHeader = "application/xml";
    int responseCode;
    boolean error;
    String errorMessage;
    boolean empty;
    XMLEventReader reader;
    InputStream inputStream;
    CloseableHttpResponse response;
    protected String proxyHost = null;
    protected int proxyPort = -1;
    protected String proxyProtocol = null;
    protected URI connectionUri;
    protected int connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    protected int readTimeout = DEFAULT_READ_TIMEOUT;
    protected boolean validate = false;
    public static int DEFAULT_CONNECT_TIMEOUT;
    public static int DEFAULT_READ_TIMEOUT;
    private static final Logger logger;

    public abstract URI formURI() throws URISyntaxException;

    public abstract URL getSchemaURL();

    public void connect() throws URISyntaxException, FDSNWSException {
        this.connectionUri = this.formURI();
        try {
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(this.getConnectTimeout()).setConnectionRequestTimeout(this.getConnectTimeout()).setSocketTimeout(this.getReadTimeout()).setRedirectsEnabled(true);
            if (this.getProxyHost() != null) {
                HttpHost proxy = new HttpHost(this.getProxyHost(), this.getProxyPort(), this.getProxyProtocol());
                requestConfigBuilder.setProxy(proxy);
            }
            RequestConfig requestConfig = requestConfigBuilder.build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            HttpGet request = new HttpGet(this.connectionUri);
            request.setHeader("User-Agent", this.getUserAgent());
            request.setHeader("Accept", this.getAcceptHeader());
            TimeQueryLog.add(this.connectionUri);
            this.response = httpClient.execute((HttpUriRequest)request);
            this.processConnection(this.response);
        }
        catch (IOException e) {
            throw new FDSNWSException("Problem with connection", e, this.connectionUri);
        }
        catch (RuntimeException e) {
            throw new FDSNWSException("Problem with connection", e, this.connectionUri);
        }
    }

    protected void processConnection(CloseableHttpResponse response) throws IOException, FDSNWSException {
        this.responseCode = response.getStatusLine().getStatusCode();
        if (this.responseCode == 204) {
            this.empty = true;
            response.close();
            response = null;
            return;
        }
        if (this.responseCode != 200) {
            this.error = true;
            this.errorMessage = "Code: " + this.responseCode + " " + AbstractFDSNQuerier.extractErrorMessage((HttpResponse)response);
            response.close();
            response = null;
            throw new FDSNWSException(this.errorMessage, this.connectionUri, this.responseCode);
        }
        HttpEntity entity = response.getEntity();
        this.inputStream = new BufferedInputStream(entity.getContent(), 65536);
    }

    public static void validate(XMLStreamReader reader, URL schemaURL) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaURL);
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(reader), null);
    }

    public void outputRaw(OutputStream out) throws MalformedURLException, IOException, URISyntaxException, FDSNWSException {
        this.connect();
        this.outputRaw(this.getInputStream(), out);
    }

    public void outputRaw(InputStream in, OutputStream out) throws IOException {
        BufferedInputStream bufIn = new BufferedInputStream(in);
        BufferedOutputStream bufOut = new BufferedOutputStream(out);
        byte[] buf = new byte[1024];
        int numRead = bufIn.read(buf);
        while (numRead != -1) {
            bufOut.write(buf, 0, numRead);
            numRead = bufIn.read(buf);
        }
        bufIn.close();
        bufOut.flush();
    }

    public String getRawXML() throws IOException {
        StringWriter out = new StringWriter();
        this.checkConnectionInitiated();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getInputStream()));
        char[] buf = new char[1024];
        int numRead = in.read(buf);
        while (numRead != -1) {
            out.write(buf, 0, numRead);
            numRead = in.read(buf);
        }
        in.close();
        out.close();
        return out.toString();
    }

    public boolean isError() {
        this.checkConnectionInitiated();
        return this.error;
    }

    public String getErrorMessage() {
        this.checkConnectionInitiated();
        return this.errorMessage;
    }

    public boolean isEmpty() {
        this.checkConnectionInitiated();
        return this.empty;
    }

    public InputStream getInputStream() {
        this.checkConnectionInitiated();
        return this.inputStream;
    }

    public URI getConnectionUri() {
        return this.connectionUri;
    }

    public boolean isConnectionInitiated() {
        return this.response != null;
    }

    public void checkConnectionInitiated() {
        if (!this.isConnectionInitiated()) {
            throw new RuntimeException("Not connected yet");
        }
    }

    public XMLEventReader getReader() throws XMLStreamException, URISyntaxException {
        if (this.reader == null && this.inputStream != null) {
            XMLInputFactory2 factory = (XMLInputFactory2)XMLInputFactory.newInstance();
            XMLStreamReader2 sr = (XMLStreamReader2)factory.createXMLStreamReader(this.getConnectionUri().toString(), this.getInputStream());
            if (this.isValidate()) {
                try {
                    XMLValidationSchema schema = schemaCache.get(this.getSchemaURL());
                    if (schema == null) {
                        if (sfactory == null) {
                            sfactory = XMLValidationSchemaFactory.newInstance((String)"http://www.w3.org/2001/XMLSchema");
                        }
                        schema = sfactory.createSchema(this.getSchemaURL());
                        schemaCache.put(this.getSchemaURL(), schema);
                    }
                    sr.validateAgainst(schema);
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException("should not happen, can't load schema in jar: " + String.valueOf(this.getSchemaURL()), e);
                }
            }
            this.reader = (XMLEventReader2)factory.createXMLEventReader((XMLStreamReader)sr);
        }
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractErrorMessage(HttpResponse response) {
        Object out = "";
        BufferedReader errReader = null;
        try {
            HttpEntity entity = response.getEntity();
            InputStream inError = entity.getContent();
            if (inError == null) {
                out = "<Empty Error Message From Server>";
            } else {
                String line;
                int lineNum;
                if ("gzip".equals(entity.getContentEncoding())) {
                    inError = new GZIPInputStream(inError);
                }
                int maxLines = 1000;
                errReader = new BufferedReader(new InputStreamReader(inError));
                for (lineNum = 0; (line = errReader.readLine()) != null && lineNum < maxLines; ++lineNum) {
                    out = (String)out + line + "\n";
                }
                if (lineNum == maxLines) {
                    out = (String)out + "...output truncated at " + maxLines + " lines.";
                }
            }
        }
        catch (IOException e) {
            out = (String)out + "\nException reading error stream: " + e.toString();
        }
        finally {
            if (errReader != null) {
                try {
                    errReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return out;
    }

    public String getAcceptHeader() {
        return this.acceptHeader;
    }

    public void setAcceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getProxyPort() {
        if (this.proxyPort <= 0) {
            return 80;
        }
        return this.proxyPort;
    }

    public void setProxyProtocol(String proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyProtocol() {
        if (this.proxyProtocol == null) {
            return "http";
        }
        return this.proxyProtocol;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    public void setConnectTimeout(int milliseconds) {
        this.connectTimeout = milliseconds;
    }

    public void setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public static Throwable extractRootCause(Throwable t) {
        if (t.getCause() == null) {
            return t;
        }
        return AbstractFDSNQuerier.extractRootCause(t.getCause());
    }

    void handleXmlStreamException(XMLStreamException e) throws FDSNWSException {
        String bufferedText = "";
        try {
            int avail = this.getInputStream().available();
            if (avail > 0) {
                byte[] b = new byte[avail];
                int numRead = this.getInputStream().read(b);
                bufferedText = new String(b, 0, numRead);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new FDSNWSException("Unable to load xml, text past error='" + bufferedText + "'", e, this.getConnectionUri());
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                logger.warn("can't close reader", (Throwable)e);
            }
            this.reader = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (MalformedChunkCodingException e) {
            }
            catch (IOException e) {
                logger.warn("can't close inputstream: " + String.valueOf(this.connectionUri), (Throwable)e);
            }
            finally {
                this.inputStream = null;
            }
            this.inputStream = null;
        }
        if (this.response != null) {
            try {
                this.response.close();
            }
            catch (SSLException e) {
            }
            catch (IOException e) {
                logger.warn("can't close response", (Throwable)e);
            }
            finally {
                this.response = null;
            }
            this.response = null;
        }
    }

    static {
        schemaCache = new HashMap();
        DEFAULT_USER_AGENT = "SeisFile-" + BuildVersion.getVersion();
        DEFAULT_CONNECT_TIMEOUT = 10000;
        DEFAULT_READ_TIMEOUT = 60000;
        logger = LoggerFactory.getLogger(AbstractFDSNQuerier.class);
    }
}

