/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SteimFrameBlock {
    private int numFrames = 0;
    private int numSamples = 0;
    private int steimVersion = 0;
    private int currentFrame = 0;
    private SteimFrame[] steimFrame = null;

    public SteimFrameBlock(int numFrames, int steimVersion) {
        this.steimFrame = new SteimFrame[numFrames];
        for (int i = 0; i < this.steimFrame.length; ++i) {
            this.steimFrame[i] = new SteimFrame();
        }
        this.numFrames = numFrames;
        this.steimVersion = steimVersion;
        this.currentFrame = 0;
        this.addEncodingNibble(0);
        ++this.steimFrame[this.currentFrame].pos;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getSteimVersion() {
        return this.steimVersion;
    }

    public SteimFrame[] getSteimFrames() {
        return this.steimFrame;
    }

    public int numNonEmptyFrames() {
        int i;
        for (i = this.steimFrame.length - 1; i >= 0 && this.steimFrame[i].isEmpty(); --i) {
        }
        return ++i;
    }

    public void trimEmptyFrames() {
        int i = this.numNonEmptyFrames();
        SteimFrame[] tmp = new SteimFrame[i];
        System.arraycopy(this.steimFrame, 0, tmp, 0, i);
        this.steimFrame = tmp;
        this.numFrames = this.steimFrame.length;
    }

    public byte[] getEncodedData() throws IOException {
        ByteArrayOutputStream encodedData = new ByteArrayOutputStream(this.numFrames * 64);
        DataOutputStream intSerializer = new DataOutputStream(encodedData);
        for (int i = 0; i < this.numFrames; ++i) {
            for (int j = 0; j < 16; ++j) {
                intSerializer.writeInt(this.steimFrame[i].word[j]);
            }
        }
        return encodedData.toByteArray();
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    protected boolean addEncodedWord(int word, int samples, int nibble) {
        int pos = this.steimFrame[this.currentFrame].pos;
        this.steimFrame[this.currentFrame].word[pos] = word;
        this.addEncodingNibble(nibble);
        this.numSamples += samples;
        if (++pos > 15) {
            ++this.currentFrame;
            if (this.currentFrame >= this.numFrames) {
                return true;
            }
            this.addEncodingNibble(0);
        }
        ++this.steimFrame[this.currentFrame].pos;
        return false;
    }

    protected void setXsubN(int word) {
        this.steimFrame[0].word[2] = word;
    }

    private void addEncodingNibble(int bitFlag) {
        int offset = this.steimFrame[this.currentFrame].pos;
        int shift = (15 - offset) * 2;
        this.steimFrame[this.currentFrame].word[0] = this.steimFrame[this.currentFrame].word[0] | bitFlag << shift;
    }

    private class SteimFrame {
        public int[] word = new int[16];
        public int pos = 0;

        private SteimFrame() {
        }

        public boolean isEmpty() {
            return this.word[0] == 0;
        }
    }
}

