/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.updatechecker;

import com.isti.util.IstiVersion;
import com.isti.util.updatechecker.BasicUpdateCheckerClient;
import com.isti.util.updatechecker.BasicUpdateCheckerServer;
import com.isti.util.updatechecker.LocationUpdate;
import com.isti.util.updatechecker.UpdateAction;
import com.isti.util.updatechecker.UpdateInformation;
import com.isti.util.updatechecker.XMLUpdateCheckerServer;

public class XMLUpdateCheckerClient
extends BasicUpdateCheckerClient {
    protected static boolean debug = false;
    protected final XMLUpdateCheckerServer xmlServer;

    public XMLUpdateCheckerClient(String versionString, String updateLocationString) {
        this(new IstiVersion(versionString), updateLocationString);
    }

    public XMLUpdateCheckerClient(IstiVersion version, String updateLocationString) {
        this(version, new XMLUpdateCheckerServer(updateLocationString));
    }

    public XMLUpdateCheckerClient(IstiVersion version, XMLUpdateCheckerServer xmlServer) {
        super(version, xmlServer);
        this.xmlServer = xmlServer;
    }

    public boolean getErrorFlag() {
        return this.xmlServer.getErrorFlag();
    }

    public String getErrorMessage() {
        return this.xmlServer.getErrorMessage();
    }

    public static void main(String[] args) {
        String versionString = "0.0.2";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().equals("debug")) {
                debug = true;
                continue;
            }
            versionString = args[i];
        }
        String localUpdateLocationString = "src/com/isti/util/updatechecker/UpdateChecker.xml";
        String remoteUpdateLocationString = "http://www.isti.com/~kevin/UpdateChecker.xml";
        XMLUpdateCheckerClient updateChecker = new XMLUpdateCheckerClient(versionString, "src/com/isti/util/updatechecker/UpdateChecker.xml");
        if (debug) {
            System.out.println(updateChecker);
            System.out.println("Update is" + (updateChecker.isUpdateAvailable() ? "" : " not") + " available");
        }
        UpdateInformation[] updates = updateChecker.getUpdates();
        if (debug) {
            System.out.println(BasicUpdateCheckerServer.toString(updates));
        } else {
            String installer = "No updates available";
            if (updates.length > 0) {
                UpdateAction[] actions = updates[updates.length - 1].getUpdateActions();
                installer = actions.length <= 0 ? "No installers available" : (actions[0] instanceof LocationUpdate ? ((LocationUpdate)actions[0]).getLocation() : actions[0].getDescription());
            }
            System.out.println("\nInstaller:\n" + installer);
        }
    }
}

