/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.UtilFns;
import com.isti.util.propertyeditor.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ValueArrayPropertyEditor
extends AbstractPropertyEditor {
    protected final JComboBox comboBox;
    private final boolean useListFlag;

    public ValueArrayPropertyEditor() {
        this.comboBox = new JComboBox();
        this.useListFlag = true;
    }

    public ValueArrayPropertyEditor(Object[] validValuesArr) {
        this.comboBox = new JComboBox<Object>(validValuesArr);
        this.useListFlag = false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        JPanel panel = new JPanel();
        panel.add(this.comboBox);
        return panel;
    }

    public void setValue(Object someObj) {
        if (someObj == null) {
            return;
        }
        this.setAsText(someObj.toString());
    }

    public void setAsText(String text) {
        if (text == null) {
            return;
        }
        if (this.useListFlag) {
            Object[] items = UtilFns.listStringToVector(text).toArray();
            this.comboBox.setModel(new DefaultComboBoxModel<Object>(items));
            return;
        }
        this.setSelectedItem(text);
        if (this.comboBox.getSelectedItem().equals(text)) {
            return;
        }
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            Object someObj = this.comboBox.getItemAt(i);
            if (!someObj.toString().equalsIgnoreCase(text)) continue;
            this.setSelectedItem(someObj.toString());
            return;
        }
    }

    public Object getValue() {
        Object selectedItem = this.comboBox.getSelectedItem();
        if (this.useListFlag) {
            int itemCount = this.comboBox.getItemCount();
            Vector<Object> items = new Vector<Object>(itemCount);
            items.add(selectedItem);
            for (int i = 0; i < itemCount; ++i) {
                Object item = this.comboBox.getItemAt(i);
                if (item.equals(selectedItem)) continue;
                items.add(item);
            }
            return UtilFns.enumToListString(items.elements());
        }
        return selectedItem;
    }

    public String getAsText() {
        return this.getValue().toString();
    }

    public void addActionListener(ActionListener l) {
        this.comboBox.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.comboBox.removeActionListener(l);
    }

    protected void setSelectedItem(String anObject) {
        this.comboBox.setSelectedItem(anObject);
    }
}

