/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.JCrypt;
import com.isti.util.UtilFns;
import com.isti.util.propertyeditor.PropertyEditorInformation;
import com.isti.util.propertyeditor.ShowDialogPropertyEditor;
import java.beans.PropertyEditor;

public class LoginInformation
implements PropertyEditorInformation {
    private static final String SEPARATOR_STRING = ", ";
    private static final String SPECIAL_CHARS_STR = "\"\r\n\t\\#=";
    private PropertyEditor propertyEditorObj = null;
    private final String usernameText;
    private String passwordText;
    private boolean isEncryptedFlag;
    private String encryptedPassword = null;
    private String loginInfoText = null;
    private static String loginDialogMsgStr = "Enter the login information to be used when connecting to the server:";
    private static String failMsgPrefixStr = "Unable to connect to the server:  \"";
    private static String failMsgSuffixStr = "\" \n\n";

    public LoginInformation() {
        this("", "");
    }

    public LoginInformation(String loginInfoStr) {
        int separatorIndex = loginInfoStr.indexOf(SEPARATOR_STRING);
        if (separatorIndex >= 0) {
            this.usernameText = loginInfoStr.substring(0, separatorIndex - 1);
            this.passwordText = loginInfoStr.substring(separatorIndex + SEPARATOR_STRING.length(), loginInfoStr.length());
        } else {
            this.usernameText = loginInfoStr;
            this.passwordText = "";
        }
        this.isEncryptedFlag = true;
    }

    public LoginInformation(String usernameText, String passwordText) {
        this(usernameText, passwordText, passwordText.length() <= 0);
    }

    public LoginInformation(String usernameText, String passwordText, boolean isEncryptedFlag) {
        this.usernameText = usernameText;
        this.passwordText = passwordText;
        this.isEncryptedFlag = isEncryptedFlag;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoginInformation)) {
            return false;
        }
        return this.equals((LoginInformation)obj);
    }

    public boolean equals(LoginInformation loginInformationObj) {
        if (loginInformationObj == null) {
            return false;
        }
        return this.getLoginInfoText().equals(loginInformationObj.getLoginInfoText());
    }

    public void clearEncryptedPassword() {
        this.encryptedPassword = null;
    }

    public String getEncryptedPasswordText() {
        if (this.encryptedPassword == null) {
            this.encryptedPassword = this.isEncryptedFlag ? this.passwordText : this.createEncryptedPassword();
        }
        return this.encryptedPassword;
    }

    protected void setPasswordText(String pwdStr, boolean isEncFlg) {
        this.passwordText = pwdStr;
        this.isEncryptedFlag = isEncFlg;
    }

    public String getPasswordText() {
        return this.passwordText;
    }

    public String getUsernameText() {
        return this.usernameText;
    }

    public boolean isEncrypted() {
        return this.isEncryptedFlag;
    }

    public boolean isValueStringQuoted() {
        return true;
    }

    public void setPropertyEditor(PropertyEditor propertyEditorObj) {
        this.propertyEditorObj = propertyEditorObj;
        if (propertyEditorObj != null) {
            propertyEditorObj.setValue(this);
            if (propertyEditorObj instanceof ShowDialogPropertyEditor) {
                ((ShowDialogPropertyEditor)propertyEditorObj).setLoginDialogMsgStr(loginDialogMsgStr);
            }
        }
    }

    public void copyLoginInfoResources(LoginInformation srcInfoObj) {
        this.setPropertyEditor(srcInfoObj.propertyEditorObj);
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditorObj;
    }

    public boolean showLoginDialog() {
        return this.showLoginDialog(null);
    }

    public boolean showLoginDialog(String panelPromptStr) {
        PropertyEditor pEditObj = this.getPropertyEditor();
        if (pEditObj instanceof ShowDialogPropertyEditor) {
            return ((ShowDialogPropertyEditor)pEditObj).showEditorDialog(panelPromptStr);
        }
        return false;
    }

    public boolean loginAttemptFailed(String messageStr) {
        if (messageStr != null && messageStr.length() > 0) {
            messageStr = failMsgPrefixStr + messageStr + failMsgSuffixStr;
        }
        return this.showLoginDialog(messageStr);
    }

    public void clearLoginInfoText() {
        this.loginInfoText = null;
    }

    public String getLoginInfoText() {
        if (this.loginInfoText == null) {
            this.loginInfoText = "\"" + LoginInformation.insertQuoteChars(this.usernameText) + "\"";
            String pwdStr = this.getEncryptedPasswordText();
            if (pwdStr.length() > 0) {
                this.loginInfoText = this.loginInfoText + ", \"" + LoginInformation.insertQuoteChars(pwdStr) + "\"";
            }
        }
        return this.loginInfoText;
    }

    public String toString() {
        return this.getLoginInfoText();
    }

    protected String createEncryptedPassword() {
        return JCrypt.crypt(this.usernameText, this.passwordText);
    }

    protected static String insertQuoteChars(String dataStr) {
        return UtilFns.insertQuoteChars(dataStr, SPECIAL_CHARS_STR);
    }

    public static void setLoginDialogMsgStrs(String loginDialogMsgStr, String failMsgPrefixStr, String failMsgSuffixStr) {
        LoginInformation.loginDialogMsgStr = loginDialogMsgStr;
        LoginInformation.failMsgPrefixStr = failMsgPrefixStr;
        LoginInformation.failMsgSuffixStr = failMsgSuffixStr;
    }
}

