/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.FifoHashtable;
import com.isti.util.IstiNamedValueInterface;
import com.isti.util.propertyeditor.PropertyComponentPanel;
import com.isti.util.propertyeditor.PropertyEditorFactory;
import java.awt.Component;
import java.beans.PropertyEditor;

public class IstiNamedValueComponentPanel
extends PropertyComponentPanel {
    private FifoHashtable editors = new FifoHashtable();

    public void addProperties(IstiNamedValueInterface[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.addProperty(items[i]);
        }
    }

    public void addProperty(IstiNamedValueInterface item) {
        Component propertyLabel = PropertyEditorFactory.createPropertyLabel(item);
        PropertyEditor editor = PropertyEditorFactory.createPropertyEditor(item);
        editor.setValue(item.getValue());
        super.addProperty(propertyLabel, editor);
        this.editors.put(item, editor);
    }

    public void addProperty(Component propertyLabel, PropertyEditor propertyeditor) {
        super.addProperty(propertyLabel, propertyeditor);
    }

    public void addProperty(Component propertyLabel, Component propertyeditor) {
        super.addProperty(propertyLabel, propertyeditor);
    }

    public IstiNamedValueInterface[] getDefaultProperties() {
        IstiNamedValueInterface[] defaultItems = new IstiNamedValueInterface[this.editors.size()];
        this.editors.keySet().toArray(defaultItems);
        return defaultItems;
    }

    public IstiNamedValueInterface[] getProperties() {
        IstiNamedValueInterface[] defaultItems = this.getDefaultProperties();
        int itemsLength = defaultItems.length;
        IstiNamedValueInterface[] items = new IstiNamedValueInterface[itemsLength];
        for (int i = 0; i < itemsLength; ++i) {
            PropertyEditor editor = (PropertyEditor)this.editors.get(defaultItems[i]);
            items[i] = (IstiNamedValueInterface)defaultItems[i].clone();
            items[i].setValueString(editor.getAsText());
        }
        return items;
    }

    public PropertyEditor getPropertyEditor(IstiNamedValueInterface defaultItem) {
        return (PropertyEditor)this.editors.get(defaultItem);
    }
}

