/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.UtilFns;
import com.isti.util.gui.IstiColorSelector;
import com.isti.util.propertyeditor.AbstractPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;

public class ColorPropertyEditor
extends AbstractPropertyEditor {
    public static final String DEF_TITLE_STR = "Select Color";
    protected final IstiColorSelector colorSelector = new IstiColorSelector(Color.white, "Select Color");

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this.colorSelector.getSelectionComponent();
    }

    public void setValue(Object someObj) {
        Color colorValueObj;
        if (someObj == null) {
            return;
        }
        if (someObj instanceof Color) {
            colorValueObj = (Color)someObj;
        } else {
            String text = someObj.toString();
            try {
                colorValueObj = UtilFns.parseColor(text);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException();
            }
        }
        this.colorSelector.setSelectedColor(colorValueObj);
    }

    public void setAsText(String text) {
        if (text == null) {
            return;
        }
        this.setValue(text);
    }

    public Object getValue() {
        return this.colorSelector.getSelectedColor();
    }

    public String getAsText() {
        return UtilFns.colorToPropertyString((Color)this.getValue());
    }

    public void addActionListener(ActionListener l) {
        this.colorSelector.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.colorSelector.removeActionListener(l);
    }
}

