/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.ProgramInformationInterface;
import com.isti.util.UtilFns;
import com.isti.util.gui.ViewHTMLPanelHandler;
import com.isti.util.propertyeditor.CfgPropertyInspector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CfgSettingsDialog {
    private final ProgramInformationInterface progInfo;
    private CfgPropertyInspector cfgPropertyInspector = null;

    public CfgSettingsDialog(ProgramInformationInterface progInfo) {
        this.progInfo = progInfo;
    }

    public void createSettingsDialog() {
        this.cfgPropertyInspector = new CfgPropertyInspector(this.progInfo.getProgramCfgProperties());
        this.cfgPropertyInspector.addHelpActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evtObj) {
                if (CfgSettingsDialog.this.cfgPropertyInspector != null) {
                    CfgSettingsDialog.this.showSettingsManualDialog(CfgSettingsDialog.this.cfgPropertyInspector, CfgSettingsDialog.this.cfgPropertyInspector.getCurrentTabName());
                }
            }
        });
    }

    public CfgPropertyInspector getCfgPropertyInspector() {
        return this.cfgPropertyInspector;
    }

    public void clearCfgPropertyInspector() {
        this.cfgPropertyInspector = null;
    }

    public ProgramInformationInterface getProgramInformation() {
        return this.progInfo;
    }

    public void setupSettingsDialog() {
        if (this.cfgPropertyInspector == null) {
            this.createSettingsDialog();
        }
    }

    public final void showSettingsDialog(String tabNameStr) {
        this.showSettingsDialog(tabNameStr, false);
    }

    public void showSettingsDialog(boolean waitFlag) {
        this.showSettingsDialog(null, waitFlag);
    }

    public void showSettingsDialog() {
        this.showSettingsDialog(null, false);
    }

    public final void showSettingsDialog(String tabNameStr, boolean waitFlag) {
        this.setupSettingsDialog();
        if (tabNameStr != null) {
            this.cfgPropertyInspector.setSelectedTabName(tabNameStr);
        }
        String settingsNameStr = this.progInfo.getSettingsConfigGroupName();
        this.cfgPropertyInspector.showDialog(this.progInfo.getProgramFrameObj(), settingsNameStr, settingsNameStr, false, waitFlag);
    }

    public void showSettingsManualDialog(Component parentComponent, String tabStr) {
        ViewHTMLPanelHandler viewHTMLPanelHandler = this.progInfo.getViewHTMLPanelHandler();
        if (viewHTMLPanelHandler == null) {
            return;
        }
        String settingsManualFilename = this.progInfo.getSettingsManualFilename();
        if (settingsManualFilename == null) {
            return;
        }
        String settingsManualTitleString = this.progInfo.getSettingsManualTitleString();
        if (settingsManualTitleString == null) {
            return;
        }
        viewHTMLPanelHandler.showFileDialog(settingsManualFilename, settingsManualTitleString, parentComponent, tabStr != null ? UtilFns.stripChar(tabStr, ' ') : null);
    }
}

