/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.menu;

import com.isti.util.menu.IstiMenuListener;
import java.awt.AWTEvent;
import java.awt.CheckboxMenuItem;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;

public class IstiMenuHandler
implements IstiMenuListener,
ActionListener,
ItemListener {
    public void processMenuItemEvent(String name, String displayText, boolean isSelected, AWTEvent e) {
        if (displayText != null) {
            System.out.println(this.getClass() + ".processMenuItemEvent: " + (isSelected ? "selected " : "") + displayText);
        }
    }

    public boolean isMenuItemSelected(String name, String displayText) {
        return false;
    }

    public boolean isMenuItemSelected(Object menuItem) {
        String name = null;
        String displayText = null;
        if (menuItem instanceof MenuItem) {
            MenuItem mi = (MenuItem)menuItem;
            name = mi.getName();
            displayText = mi.getLabel();
        } else if (menuItem instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)menuItem;
            name = ab.getName();
            displayText = ab.getText();
        }
        return this.isMenuItemSelected(name, displayText);
    }

    protected void processMenuItemEvent(AWTEvent e) {
        String name = null;
        String displayText = null;
        boolean isSelected = false;
        Object menuItem = e.getSource();
        if (menuItem instanceof MenuItem) {
            MenuItem mi = (MenuItem)menuItem;
            name = mi.getName();
            displayText = mi.getLabel();
            if (menuItem instanceof CheckboxMenuItem) {
                CheckboxMenuItem cmi = (CheckboxMenuItem)menuItem;
                isSelected = cmi.getState();
            }
        } else if (menuItem instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)menuItem;
            name = ab.getName();
            displayText = ab.getText();
            isSelected = ab.isSelected();
        }
        this.processMenuItemEvent(name, displayText, isSelected, e);
    }

    public void actionPerformed(ActionEvent e) {
        this.processMenuItemEvent(e);
    }

    public void itemStateChanged(ItemEvent e) {
        this.processMenuItemEvent(e);
    }
}

