/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.gui.GuiUtilFns;
import com.isti.util.gui.textvalidator.AbstractValidatedDocument;
import com.isti.util.gui.textvalidator.TextValidator;
import com.isti.util.gui.textvalidator.TextValidatorDocument;
import com.isti.util.gui.textvalidator.ValidatedDocument;
import com.isti.util.gui.textvalidator.ValidatedTextComponent;
import java.awt.Font;
import javax.swing.JTextField;

public class ValidatedJTextField
extends JTextField
implements ValidatedTextComponent {
    private static final long serialVersionUID = 1L;
    private final AbstractValidatedDocument document;
    private int columnWidth = 0;

    public ValidatedJTextField(AbstractValidatedDocument document) {
        super(document, null, ValidatedJTextField.getColumns(document));
        this.document = document;
        this.setTextValidator(document != null ? document.getTextValidator() : null);
    }

    public ValidatedJTextField(TextValidator tv) {
        this(ValidatedJTextField.getTextValidatorDocument(tv));
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            int columnWidth = 0;
            if (this.document != null && !this.document.isAllowed('m')) {
                columnWidth = GuiUtilFns.getMaxCharWidth(this, this.document.getSpecialChars(), this.document.getAllowedFlag());
            }
            if (columnWidth == 0) {
                columnWidth = super.getColumnWidth();
            }
            this.columnWidth = columnWidth;
        }
        return this.columnWidth;
    }

    public double getDoubleValue() {
        try {
            if (this.getText() != null && this.getText().length() > 0) {
                return Double.parseDouble(this.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public static TextValidatorDocument getTextValidatorDocument(TextValidator tv) {
        if (tv == null) {
            return null;
        }
        return new TextValidatorDocument(tv);
    }

    public static ValidatedDocument getValidatedDocument(TextValidator tv) {
        if (tv == null) {
            return null;
        }
        return new ValidatedDocument(tv.getSpecialChars(), tv.isNumeric(), tv.getMaxNumChars(), tv.getAllowedFlag());
    }

    public int getIntegerValue() {
        try {
            if (this.getText() != null && this.getText().length() > 0) {
                return Integer.parseInt(this.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public TextValidator getTextValidator() {
        if (this.document != null) {
            return this.document.getTextValidator();
        }
        return null;
    }

    protected static int getColumns(AbstractValidatedDocument document) {
        int columns = 0;
        if (document != null && (columns = document.getColumns()) < 0) {
            columns = document.getMaxNumChars();
        }
        return columns;
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.columnWidth = 0;
    }

    public final ValidatedJTextField setTextValidator(TextValidator tv) {
        int newColumns;
        int oldColumns;
        String toolTipText = this.getToolTipText();
        if (toolTipText == null || toolTipText.length() <= 0) {
            if (tv != null) {
                toolTipText = tv.getToolTipText();
            }
            if (toolTipText != null) {
                this.setToolTipText(toolTipText);
            }
        }
        boolean tvChangedFlag = false;
        if (this.document != null && this.document.getTextValidator() != tv) {
            this.document.setTextValidator(tv);
            tvChangedFlag = true;
        }
        if ((oldColumns = this.getColumns()) != (newColumns = ValidatedJTextField.getColumns(this.document))) {
            this.setColumns(newColumns);
        } else if (tvChangedFlag) {
            this.invalidate();
            this.columnWidth = 0;
        }
        return this;
    }

    public void setValue(int val) {
        this.setText(Integer.toString(val));
    }

    public void setValue(double val) {
        this.setText(Double.toString(val));
    }

    public void setValue(Object val) {
        String s = val != null ? val.toString() : null;
        this.setText(s);
    }
}

