/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.gui.textvalidator.SQLTextUtils;
import com.isti.util.gui.textvalidator.TextBasicValidator;

public class TextSQLTimeValidator
extends TextBasicValidator {
    public static final String TIME_DESCRIPTION_TEXT = "hours:minutes:seconds";
    public static final String TIME_FORMAT_TEXT = "hh:mm:ss";
    public static final String SEPARATOR_CHARS = ":";
    public static final String ALLOWED_CHARS = "0123456789:";
    private static final String TOOLTIP_TEXT = "hours:minutes:seconds (hh:mm:ss)";

    public TextSQLTimeValidator() {
        super(ALLOWED_CHARS, TIME_FORMAT_TEXT.length(), TOOLTIP_TEXT, false, TIME_FORMAT_TEXT.length(), true);
    }

    public boolean isValid(String s) {
        return TextSQLTimeValidator.isValidTime(s);
    }

    public static boolean isValidTime(String s) {
        int integerCharCount = 0;
        int integerFieldCount = 0;
        int separatorCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ("0123456789".indexOf(c) >= 0) {
                if (++integerCharCount == 1) {
                    if (++integerFieldCount <= 3) continue;
                    return false;
                }
                int maxIntegerCharCount = 2;
                if (integerCharCount <= 2) continue;
                return false;
            }
            if (SEPARATOR_CHARS.indexOf(c) >= 0) {
                if (i != 0 && integerCharCount == 0) {
                    return false;
                }
                if (++separatorCount > 2) {
                    return false;
                }
                integerCharCount = 0;
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isValidEntry(String s) {
        try {
            return SQLTextUtils.getTimeValue(s) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

