/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.gui.textvalidator.TextMinMaxValidator;

public class TextNumberValidator
extends TextMinMaxValidator {
    private static final boolean defaultNumericFlag = true;
    private static final int defaultMaxNumChars = 0;

    public TextNumberValidator(boolean isFloatFlag, boolean isSignedFlag, int numColumns) {
        this(TextNumberValidator.getAllowedNumberChars(isFloatFlag, isSignedFlag), numColumns, null, null);
    }

    public TextNumberValidator(Comparable minNumber, Comparable maxNumber, int numColumns) {
        this(TextNumberValidator.getAllowedNumberChars(minNumber, maxNumber), numColumns, minNumber, maxNumber);
    }

    public TextNumberValidator(double minNumber, double maxNumber, int numColumns) {
        this(new Double(minNumber), new Double(maxNumber), numColumns);
    }

    public TextNumberValidator(long minNumber, long maxNumber, int numColumns) {
        this(new Long(minNumber), new Long(maxNumber), numColumns);
    }

    public TextNumberValidator(String allowedChars, int numColumns, Comparable min, Comparable max) {
        super(allowedChars, numColumns, true, 0, min, max);
    }

    public static final String getAllowedNumberChars(boolean isFloatFlag, boolean isSignedFlag) {
        String allowedChars = isFloatFlag ? (isSignedFlag ? "0123456789.-+eE" : "0123456789.eE") : (isSignedFlag ? "0123456789-+" : "0123456789");
        return allowedChars;
    }

    public static final String getAllowedNumberChars(Comparable minNumber, Comparable maxNumber) {
        return TextNumberValidator.getAllowedNumberChars(TextNumberValidator.isFloat(minNumber, maxNumber), TextNumberValidator.isSigned(minNumber, maxNumber));
    }

    public static final boolean isFloat(Comparable minNumber, Comparable maxNumber) {
        return TextNumberValidator.isFloat(minNumber) || TextNumberValidator.isFloat(maxNumber);
    }

    public static final boolean isFloat(Comparable n) {
        return n instanceof Float || n instanceof Double;
    }

    public static final boolean isSigned(Comparable minNumber, Comparable maxNumber) {
        return TextNumberValidator.isSigned(minNumber);
    }

    public static final boolean isSigned(Comparable n) {
        if (n instanceof Number) {
            return ((Number)((Object)n)).doubleValue() < 0.0;
        }
        return true;
    }
}

