/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.gui.textvalidator.TextValidator;

public class TextBasicValidator
implements TextValidator {
    private boolean allowedFlag = true;
    private String specialChars = null;
    private int numColumns = -1;
    private String toolTipText = null;
    private boolean numericFlag = false;
    private int maxNumChars = 0;
    private int[] allowedNumChars = null;

    public TextBasicValidator() {
    }

    public TextBasicValidator(int maxTextLength) {
        this.setMaxTextLength(maxTextLength);
    }

    public TextBasicValidator(int[] allowedNumChars) {
        this.allowedNumChars = allowedNumChars;
        if (allowedNumChars != null) {
            int maxTextLength = 0;
            for (int i = 0; i < allowedNumChars.length; ++i) {
                int numChars = allowedNumChars[i];
                if (numChars <= maxTextLength) continue;
                maxTextLength = numChars;
            }
            this.setMaxTextLength(maxTextLength);
        }
    }

    public TextBasicValidator(String specialChars, int numColumns, String toolTipText, boolean numericFlag, int maxNumChars, boolean allowedFlag) {
        this.allowedFlag = allowedFlag;
        this.specialChars = specialChars;
        this.numColumns = numColumns;
        this.toolTipText = toolTipText;
        this.numericFlag = numericFlag;
        this.maxNumChars = maxNumChars;
    }

    public boolean getAllowedFlag() {
        return this.allowedFlag;
    }

    public int getColumns() {
        return this.numColumns;
    }

    public int getMaxNumChars() {
        return this.maxNumChars;
    }

    public String getSpecialChars() {
        return this.specialChars;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public boolean isNumeric() {
        return this.numericFlag;
    }

    public boolean isValid(String s) {
        return true;
    }

    public boolean isValidEntry(String s) {
        boolean validFlag = this.isValid(s);
        if (validFlag && this.allowedNumChars != null) {
            validFlag = false;
            int numChars = s.length();
            for (int i = 0; i < this.allowedNumChars.length; ++i) {
                if (numChars != this.allowedNumChars[i]) continue;
                validFlag = true;
                break;
            }
        }
        return validFlag;
    }

    public void setAllowedFlag(boolean b) {
        this.allowedFlag = b;
    }

    public void setColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public void setMaxNumChars(int maxNumChars) {
        this.maxNumChars = maxNumChars;
    }

    public final void setMaxTextLength(int maxTextLength) {
        this.numColumns = maxTextLength;
        this.maxNumChars = maxTextLength;
    }

    public void setNumericFlag(boolean b) {
        this.numericFlag = b;
    }

    public void setSpecialChars(String specialChars) {
        this.specialChars = specialChars;
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }
}

