/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;

public class SQLTextUtils {
    public static long DEFAULT_EPOCH_TIME_VALUE = 0L;
    public static Time DEFAULT_TIME_VALUE = new Time(0L);

    public static Date getDateValue(String s) {
        return SQLTextUtils.getDateValue(s, DEFAULT_EPOCH_TIME_VALUE);
    }

    public static Date getDateValue(String s, long defaultEpochTime) {
        if (s.length() <= 0) {
            return new Date(defaultEpochTime);
        }
        return Date.valueOf(s);
    }

    public static Timestamp getTimestampValue(String dateText, String timeText) {
        return SQLTextUtils.getTimestampValue(dateText, timeText, DEFAULT_EPOCH_TIME_VALUE);
    }

    public static Timestamp getTimestampValue(String dateText, String timeText, long defaultEpochTime) {
        int dateTextLength = dateText.length();
        int timeTextLength = timeText.length();
        if (dateTextLength <= 0 && timeTextLength <= 0) {
            return new Timestamp(defaultEpochTime);
        }
        if (dateTextLength <= 0) {
            dateText = new Date(defaultEpochTime).toString();
        }
        if (timeTextLength <= 0) {
            timeText = "00:00:00";
        }
        String s = dateText + " " + timeText;
        try {
            return Timestamp.valueOf(s);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static Timestamp getTimestampValue(String s) {
        return SQLTextUtils.getTimestampValue(s, DEFAULT_EPOCH_TIME_VALUE);
    }

    public static Timestamp getTimestampValue(String s, long defaultEpochTime) {
        try {
            return new TimestampText(s, defaultEpochTime).getTimestampValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Time getTimeValue(String s) {
        return SQLTextUtils.getTimeValue(s, DEFAULT_TIME_VALUE);
    }

    public static Time getTimeValue(String s, Time defaultTime) {
        if (s.length() <= 0) {
            return defaultTime;
        }
        return Time.valueOf(s);
    }

    public static class TimestampText {
        private final String dateText;
        private final String timeText;
        private final String msText;
        private final long defaultEpochTime;

        public TimestampText(String s) {
            this(s, DEFAULT_EPOCH_TIME_VALUE);
        }

        public TimestampText(String s, long defaultEpochTime) throws IllegalArgumentException {
            String dateText = "";
            String timeText = "";
            String msText = "";
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s, " .");
                if (st.countTokens() > 3) {
                    throw new IllegalArgumentException();
                }
                if (st.hasMoreTokens()) {
                    dateText = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    timeText = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    msText = st.nextToken();
                }
            }
            this.dateText = dateText;
            this.timeText = timeText;
            this.msText = msText;
            this.defaultEpochTime = defaultEpochTime;
        }

        public String getDateText() {
            return this.dateText;
        }

        public long getDefaultEpochTime() {
            return this.defaultEpochTime;
        }

        public String getMillisecondsText() {
            return this.msText;
        }

        public Timestamp getTimestampValue() {
            return SQLTextUtils.getTimestampValue(this.dateText, this.timeText, this.defaultEpochTime);
        }

        public String getTimeText() {
            return this.timeText;
        }
    }
}

