/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.FileUtils;
import com.isti.util.ILaunchBrowser;
import com.isti.util.LaunchBrowser;
import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import com.isti.util.gui.IstiDialogUtil;
import com.isti.util.gui.ViewHTMLPanel;
import java.awt.Component;
import java.net.URL;
import java.util.Hashtable;

public class ViewHTMLPanelHandler {
    public static final String[] DEFAULT_SHOW_BACK_LAUNCH_FILES = new String[]{"Settings"};
    private static final String SHOW_FILE = "ShowFile";
    private static final int SHOW_FILE_LEN = "ShowFile".length();
    private final IstiDialogUtil dialogUtilObj;
    private final LaunchBrowser launchBrowserObj;
    private final String[] showBackLaunchFiles;
    private Hashtable viewHTMLPanelTable = new Hashtable();

    public ViewHTMLPanelHandler(IstiDialogUtil dialogUtilObj, LaunchBrowser launchBrowserObj) {
        this(dialogUtilObj, launchBrowserObj, DEFAULT_SHOW_BACK_LAUNCH_FILES);
    }

    public ViewHTMLPanelHandler(IstiDialogUtil dialogUtilObj, LaunchBrowser launchBrowserObj, String[] showBackLaunchFiles) {
        this.dialogUtilObj = dialogUtilObj;
        this.launchBrowserObj = launchBrowserObj != null ? launchBrowserObj : new LaunchBrowser();
        this.showBackLaunchFiles = showBackLaunchFiles;
    }

    public ViewHTMLPanel buildShowViewerDialog(ViewHTMLPanel vPanelObj, String fNameStr, Component parentComponent, String titleStr, boolean modalFlag, Object button1Obj, Object button2Obj, boolean showBackLaunchFlag, String viewRefStr) {
        try {
            if (vPanelObj == null) {
                vPanelObj = this.buildViewerDialog(fNameStr, showBackLaunchFlag, viewRefStr);
                if (vPanelObj == null) {
                    String msgStr = "Unable to open " + titleStr + " file \"" + fNameStr + "\"";
                    if (this.dialogUtilObj != null) {
                        this.dialogUtilObj.popupErrorMessage(LogFile.getGlobalLogObj(false), msgStr, false);
                    }
                    return null;
                }
                if (!vPanelObj.getDialogClosedFlag()) {
                    vPanelObj.showInDialog(parentComponent, titleStr, modalFlag, button1Obj, button2Obj);
                } else {
                    vPanelObj = null;
                }
            } else {
                vPanelObj.resetViewer();
                if (viewRefStr != null) {
                    vPanelObj.setPageRef(viewRefStr);
                }
                if (!vPanelObj.isVisible()) {
                    vPanelObj.showInDialog(parentComponent, titleStr, modalFlag, button1Obj, button2Obj);
                } else {
                    vPanelObj.requestFocus();
                }
            }
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Error displaying " + titleStr + " file \"" + fNameStr + "\":  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
        }
        return vPanelObj;
    }

    public static String getFileNameForMenuName(String menuNameStr) {
        if (ViewHTMLPanelHandler.isShowFileMenuName(menuNameStr)) {
            return menuNameStr.substring(SHOW_FILE_LEN);
        }
        return menuNameStr;
    }

    public static boolean isShowFileMenuName(String menuNameStr) {
        return menuNameStr.startsWith(SHOW_FILE);
    }

    public void showFileDialog(String nameStr, String titleStr, Component parentComponent) {
        String fNameStr = ViewHTMLPanelHandler.getFileNameForMenuName(nameStr);
        this.showFileDialog(fNameStr, titleStr, parentComponent, null);
    }

    public void showFileDialog(String fNameStr, String titleStr, Component parentComponent, String viewRefStr) {
        this.showFileDialog(fNameStr, titleStr, parentComponent, viewRefStr, false);
    }

    public void showFileDialog(String fNameStr, String titleStr, Component parentComponent, String viewRefStr, boolean showBackLaunchFlag) {
        ViewHTMLPanel vPanelObj = (ViewHTMLPanel)this.viewHTMLPanelTable.get(fNameStr);
        if ((vPanelObj = this.buildShowViewerDialog(vPanelObj, fNameStr, parentComponent, titleStr, false, null, null, showBackLaunchFlag, viewRefStr)) != null) {
            this.viewHTMLPanelTable.put(fNameStr, vPanelObj);
        }
    }

    protected ViewHTMLPanel buildViewerDialog(String fNameStr, boolean showBackLaunchFlag, String initialRefStr) {
        URL urlObj;
        if (!showBackLaunchFlag && this.showBackLaunchFiles != null) {
            for (int i = 0; i < this.showBackLaunchFiles.length; ++i) {
                if (fNameStr.indexOf(this.showBackLaunchFiles[i]) < 0) continue;
                showBackLaunchFlag = true;
            }
        }
        if ((urlObj = FileUtils.fileMultiOpenInputURL(fNameStr)) != null) {
            return new ViewHTMLPanel(urlObj, 750, 650, (ILaunchBrowser)this.launchBrowserObj, showBackLaunchFlag, showBackLaunchFlag, initialRefStr);
        }
        return null;
    }
}

