/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.TimeFilteredDocument;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TimeJTextField
extends JTextField {
    public static final int HOURS = 2;
    public static final int HOURS_MINS = 5;
    public static final int HOURS_MINS_SECS = 8;
    public static final boolean SHOW_ZERO_TEXT_FLAG_DEFAULT = true;
    private final int maxNumChars;
    protected static final String FIELD_SEPARATOR = ":";
    protected static final String MS_FIELD_SEPARATOR = ".";
    protected static final String TIME_PATTERN = "HH:mm:ss.SSS";
    protected static final String EMPTY_TIME_TEXT = "  :  :  .   ";
    protected static final int[] CALENDAR_TIME_FIELDS = new int[]{11, 12, 13, 14};
    protected final int MAX_CALENDAR_TIME_FIELD;
    public final SimpleDateFormat timeFormatterObj;
    protected static boolean debugFlag = false;
    private int caretPos = -1;
    private final boolean showZeroTextFlag;
    private Calendar calObj;
    private Calendar workingCalObj;
    private Date minDateObj;
    private Date maxDateObj;

    public TimeJTextField() {
        this(8);
    }

    public TimeJTextField(int maxNumChars) {
        this(maxNumChars, true);
    }

    public TimeJTextField(int maxNumChars, boolean showZeroTextFlag) {
        this(maxNumChars, showZeroTextFlag, null);
    }

    public TimeJTextField(final int maxNumChars, final boolean showZeroTextFlag, Calendar calObj) {
        super(maxNumChars + 1);
        this.maxNumChars = maxNumChars;
        this.showZeroTextFlag = showZeroTextFlag;
        this.MAX_CALENDAR_TIME_FIELD = (maxNumChars + 1) / 3;
        if (calObj == null) {
            calObj = Calendar.getInstance();
        }
        this.calObj = calObj;
        this.workingCalObj = (Calendar)calObj.clone();
        this.setDocument(new TimeFilteredDocument(this, maxNumChars));
        this.setTime(null);
        if (showZeroTextFlag) {
            this.setText(this.getCleanText());
        }
        this.setCaretPosition(1);
        this.setFont(new Font("Monospaced", 0, this.getFont().getSize()));
        this.timeFormatterObj = new SimpleDateFormat(TIME_PATTERN.substring(0, maxNumChars));
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int nextDot;
                int dot = e.getDot();
                int mark = e.getMark();
                try {
                    if (nextDot == TimeJTextField.this.caretPos - 1) {
                        for (nextDot = dot; Character.isSpaceChar(TimeJTextField.this.getText(nextDot, 1).charAt(0)) && nextDot > 0; --nextDot) {
                        }
                        if (nextDot == 0 && Character.isSpaceChar(TimeJTextField.this.getText(nextDot, 1).charAt(0))) {
                            nextDot = TimeJTextField.this.caretPos;
                        }
                    } else {
                        while (Character.isSpaceChar(TimeJTextField.this.getText(nextDot, 1).charAt(0))) {
                            if (nextDot >= maxNumChars) continue;
                            ++nextDot;
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (dot != nextDot) {
                    if (mark != dot) {
                        TimeJTextField.this.moveCaretPosition(nextDot);
                    } else {
                        TimeJTextField.this.setCaretPosition(nextDot);
                    }
                }
                TimeJTextField.this.caretPos = nextDot;
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String currentText;
                String cleanText;
                if (showZeroTextFlag && !(cleanText = TimeJTextField.getCleanText(currentText = TimeJTextField.this.getText())).equals(currentText)) {
                    TimeJTextField.this.setText(cleanText);
                }
            }
        });
        this.setCaretPosition(0);
    }

    public int getMaxNumChars() {
        return this.maxNumChars;
    }

    public boolean isShowZeroText() {
        return this.showZeroTextFlag;
    }

    public Date getMaxTime() {
        return this.maxDateObj;
    }

    public Date getMinTime() {
        return this.minDateObj;
    }

    public Date getTime() {
        return this.getCalendar().getTime();
    }

    public TimeZone getTimeZone() {
        return this.calObj.getTimeZone();
    }

    public Calendar getCalendar() {
        this.updateTime();
        return this.calObj;
    }

    public static Date getValidDate(Date date) {
        return TimeJTextField.getValidDate(date, false);
    }

    public static Date getValidDate(Date date, boolean ceilFlag) {
        long updateTime;
        if (date != null && (updateTime = date.getTime()) % 1000L != 0L) {
            if (ceilFlag) {
                updateTime += 999L;
            }
            updateTime /= 1000L;
            date = new Date(updateTime *= 1000L);
        }
        return date;
    }

    public boolean setMaxTime(Date date) {
        if (date != null) {
            date = TimeJTextField.getValidDate(date, false);
            if (this.minDateObj != null && date.before(this.minDateObj)) {
                return false;
            }
            if (this.getTime().after(date)) {
                this.setTime(date);
            }
        }
        this.maxDateObj = null;
        if (date != null) {
            this.maxDateObj = date;
        }
        return true;
    }

    public boolean setMinTime(Date date) {
        if (date != null) {
            date = TimeJTextField.getValidDate(date, true);
            if (this.maxDateObj != null && date.after(this.maxDateObj)) {
                return false;
            }
            if (this.getTime().before(date)) {
                this.setTime(date);
            }
        }
        this.minDateObj = null;
        if (date != null) {
            this.minDateObj = date;
        }
        return true;
    }

    public boolean setTime(Date date) {
        if (date != null) {
            date = TimeJTextField.getValidDate(date);
            if (this.minDateObj != null && date.before(this.minDateObj)) {
                return false;
            }
            if (this.maxDateObj != null && date.after(this.maxDateObj)) {
                return false;
            }
        }
        if (date != null) {
            this.calObj.setTime(date);
            this.setText(this.timeFormatterObj.format(date));
            if (!this.showZeroTextFlag) {
                int i;
                for (i = CALENDAR_TIME_FIELDS.length - 1; i >= 0 && this.calObj.get(CALENDAR_TIME_FIELDS[i]) == 0; --i) {
                }
                if (i < 0) {
                    this.setText(EMPTY_TIME_TEXT.substring(0, this.maxNumChars));
                }
            }
        } else {
            this.calObj.clear();
            this.setText(EMPTY_TIME_TEXT.substring(0, this.maxNumChars));
        }
        if (debugFlag) {
            System.out.println("Set date: " + this.calObj.getTime());
        }
        return true;
    }

    public void setTimeZone(TimeZone value) {
        this.calObj.setTimeZone(value);
        this.workingCalObj.setTimeZone(value);
        this.timeFormatterObj.setTimeZone(value);
    }

    public String toString() {
        Date time = this.getTime();
        if (time != null) {
            return this.timeFormatterObj.format(time);
        }
        return "";
    }

    protected String getCleanText() {
        return TimeJTextField.getCleanText(this.getText());
    }

    protected static String getCleanText(String text) {
        if (text != null) {
            return text.replace(' ', '0');
        }
        return text;
    }

    protected void updateTime() {
        try {
            String cleanText = this.getCleanText();
            Date date = this.timeFormatterObj.parse(cleanText);
            this.workingCalObj.setTime(date);
            for (int i = 0; i < this.MAX_CALENDAR_TIME_FIELD; ++i) {
                int field = CALENDAR_TIME_FIELDS[i];
                int value = this.workingCalObj.get(field);
                this.calObj.set(field, value);
            }
            Date newDate = this.calObj.getTime();
            if (debugFlag) {
                System.out.println("New date: " + newDate + " (" + cleanText + ")");
            }
            if (this.minDateObj != null && newDate.before(this.minDateObj)) {
                if (debugFlag) {
                    System.out.println("New date is before the min date (" + this.minDateObj + ")");
                }
                this.calObj.setTime(this.minDateObj);
                return;
            }
            if (this.maxDateObj != null && newDate.after(this.maxDateObj)) {
                if (debugFlag) {
                    System.out.println("New date is after the max date (" + this.maxDateObj + ")");
                }
                this.calObj.setTime(this.maxDateObj);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

