/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.TimeJTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class TimeFilteredDocument
extends PlainDocument {
    public static final String TIME_DIGITS = " 0123456789";
    public static final String HOURS_FIRST_DIGITS = " 0123456789".substring(0, 4);
    public static final String MINS_SECS_FIRST_DIGITS = " 0123456789".substring(0, 7);
    public static final String[] ALLOWED_CHARS = new String[]{HOURS_FIRST_DIGITS, " 0123456789", ":", MINS_SECS_FIRST_DIGITS, " 0123456789", ":", MINS_SECS_FIRST_DIGITS, " 0123456789", ".", " 0123456789", " 0123456789", " 0123456789"};
    private final TimeJTextField textField;
    private final int maxNumChars;

    public TimeFilteredDocument(TimeJTextField textField, int maxNumChars) {
        this.textField = textField;
        if (maxNumChars >= ALLOWED_CHARS.length) {
            maxNumChars = ALLOWED_CHARS.length - 1;
        }
        this.maxNumChars = maxNumChars;
    }

    protected int insertChar(int offs, char ch) throws BadLocationException {
        int currentLen = this.getLength();
        String str = new String(new char[]{ch});
        if (currentLen >= offs && Character.isDigit(ch)) {
            char cc;
            String currentText = this.getText(0, currentLen);
            if (currentLen == offs || TIME_DIGITS.indexOf(cc = currentText.charAt(offs)) < 0) {
                if (offs <= 0) {
                    return -1;
                }
                cc = currentText.charAt(--offs);
            } else if (Character.isDigit(cc)) {
                if (offs > 0 && offs == this.textField.getCaretPosition()) {
                    cc = currentText.charAt(--offs);
                }
            } else if (Character.isSpaceChar(cc)) {
                for (int i = offs + 1; i < currentLen && Character.isSpaceChar(currentText.charAt(i)); ++i) {
                    ++offs;
                }
            }
            int endIndex = offs + 1;
            while (offs > 0 && Character.isDigit(cc)) {
                cc = currentText.charAt(--offs);
            }
            if (!Character.isSpaceChar(cc)) {
                return -1;
            }
            str = currentText.substring(offs + 1, endIndex) + ch;
        }
        if (!this.isValidStr(offs, str)) {
            return -1;
        }
        int strLen = str.length();
        if (currentLen > offs) {
            super.remove(offs, strLen);
        }
        super.insertString(offs, str, null);
        return offs + strLen;
    }

    protected static boolean isValidChar(int offs, char ch) {
        return offs < ALLOWED_CHARS.length && ALLOWED_CHARS[offs].indexOf(ch) >= 0;
    }

    protected boolean isValidStr(int offs, String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (TimeFilteredDocument.isValidChar(offs + i, str.charAt(i))) continue;
            return false;
        }
        if (offs <= 1) {
            char hourSecondDigit;
            char hourFirstDigit;
            block8: {
                try {
                    hourFirstDigit = offs == 0 ? str.charAt(0) : this.getText(0, 1).charAt(0);
                    if (offs == 1) {
                        hourSecondDigit = str.charAt(0);
                        break block8;
                    }
                    if (offs == 0 && str.length() > 1) {
                        hourSecondDigit = str.charAt(1);
                        break block8;
                    }
                    if (this.getLength() > 1) {
                        hourSecondDigit = this.getText(1, 1).charAt(0);
                        break block8;
                    }
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (hourFirstDigit == '2' && hourSecondDigit >= '4') {
                return false;
            }
        }
        return true;
    }

    protected int removeChar(int offs) throws BadLocationException {
        int currentLen = this.getLength();
        if (currentLen > offs) {
            String currentText = this.getText(0, currentLen);
            char cc = currentText.charAt(offs);
            int endIndex = offs;
            if (Character.isDigit(cc)) {
                while (offs > 0 && Character.isDigit(currentText.charAt(offs - 1))) {
                    --offs;
                }
            }
            String str = "  :  :  .   ".charAt(offs) + currentText.substring(offs, endIndex);
            int strLen = str.length();
            super.remove(offs, strLen);
            super.insertString(offs, str, null);
            return offs + strLen;
        }
        return -1;
    }

    public TimeJTextField getTextField() {
        return this.textField;
    }

    public void insertString(int offs, String str, AttributeSet aSet) throws BadLocationException {
        int len;
        if (str == null || (len = str.length()) <= 0) {
            return;
        }
        int i = offs;
        for (int p = 0; p < len && (i = this.insertChar(i, str.charAt(p))) >= 0; ++p) {
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        int i = offs;
        for (int p = 0; p < len && (i = this.removeChar(i)) >= 0; ++p) {
        }
    }
}

