/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;

public class TextAreaWriter
extends Writer {
    public static final int DEF_TEXTSIZE_LIMIT = 8000000;
    public static final int DEF_TEXTTRIM_SIZE = 8000;
    public static final int DEF_MAXNL_SEARCH = 400;
    private final JTextArea textAreaObj;
    private int textSizeLimit = 8000000;
    private int textTrimSize = 8000;
    private int maxNewLineSearch = 400;
    private boolean trimExcReportedFlag = false;

    public TextAreaWriter(JTextArea textAreaObj) {
        this(textAreaObj, true);
    }

    public TextAreaWriter(JTextArea textAreaObj, boolean setupTextObjFlag) {
        this.textAreaObj = textAreaObj;
        if (setupTextObjFlag) {
            this.setupTextAreaObj();
        }
    }

    public void setupTextAreaObj() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetupTextAreaObj();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TextAreaWriter.this.doSetupTextAreaObj();
                }
            });
        }
    }

    public void doSetupTextAreaObj() {
        DefaultCaret caretObj = new DefaultCaret(){

            public void focusGained(FocusEvent e) {
                if (this.getComponent() != null && this.getComponent().isEnabled()) {
                    this.setVisible(true);
                    this.setSelectionVisible(true);
                }
            }
        };
        Caret oldCaretObj = this.textAreaObj.getCaret();
        caretObj.setBlinkRate(oldCaretObj != null ? oldCaretObj.getBlinkRate() : 500);
        this.textAreaObj.setEditable(false);
        this.textAreaObj.setCursor(Cursor.getPredefinedCursor(2));
        this.textAreaObj.setCaret(caretObj);
    }

    public void write(char[] charsArr, final int offsetVal, final int numChars) throws IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doWrite(charsArr, offsetVal, numChars);
        } else {
            final char[] cpCharsArr = new char[charsArr.length];
            System.arraycopy(charsArr, 0, cpCharsArr, 0, charsArr.length);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        TextAreaWriter.this.doWrite(cpCharsArr, offsetVal, numChars);
                    }
                    catch (IOException ex) {
                        System.err.println("Error in 'TextAreaWriter.write(char[],int,int)':  " + ex);
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public void doWrite(char[] charsArr, int offsetVal, int numChars) throws IOException {
        int endVal;
        if (offsetVal < 0 || offsetVal > charsArr.length || numChars < 0 || (endVal = offsetVal + numChars) > charsArr.length || endVal < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (numChars == 0) {
            return;
        }
        StringBuffer outBuff = new StringBuffer(numChars);
        for (int i = offsetVal; i < endVal; ++i) {
            char ch = charsArr[i];
            if (!Character.isLetterOrDigit(ch) && ch != '\n' && ch != '\t' && (ch < ' ' || ch > '~')) continue;
            outBuff.append(ch);
        }
        this.textAreaObj.append(outBuff.toString());
        this.doTextLimitAndPosCaret();
    }

    public void flush() {
    }

    public void close() {
    }

    public void setTextSizeLimitValues(int textSizeLimit, int textTrimSize, int maxNewLineSearch) {
        this.textSizeLimit = textSizeLimit;
        this.textTrimSize = textTrimSize;
        this.maxNewLineSearch = maxNewLineSearch;
    }

    public void setTextSizeLimitValues(int textSizeLimit, int textTrimSize) {
        this.setTextSizeLimitValues(textSizeLimit, textTrimSize, 0);
    }

    public int getTextTrimSize() {
        return this.textTrimSize;
    }

    public int getMaxNewLineSearch() {
        return this.maxNewLineSearch;
    }

    public int getTextSizeLimit() {
        return this.textSizeLimit;
    }

    private void doTextLimitAndPosCaret() {
        Document docObj = this.textAreaObj.getDocument();
        if (docObj != null) {
            block6: {
                int docLen = docObj.getLength();
                try {
                    if (docLen > this.textSizeLimit && docLen > this.textTrimSize * 10) {
                        String checkStr;
                        int pos;
                        int oldDocLen;
                        do {
                            docObj.remove(0, this.textTrimSize);
                            oldDocLen = docLen;
                        } while ((docLen = docObj.getLength()) > this.textSizeLimit && docLen > this.textTrimSize * 10 && docLen < oldDocLen);
                        if (this.maxNewLineSearch > 0 && (pos = (checkStr = docObj.getText(0, this.maxNewLineSearch)).indexOf(10)) >= 0) {
                            docObj.remove(0, pos + 1);
                        }
                    }
                }
                catch (Exception ex) {
                    if (this.trimExcReportedFlag) break block6;
                    this.trimExcReportedFlag = true;
                    System.err.println("Error enforcing text size limit:");
                    ex.printStackTrace();
                }
            }
            this.textAreaObj.setCaretPosition(docObj.getLength());
        }
    }
}

