/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.FocusUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class TabCloseIcon
implements Icon,
ActionListener {
    private static final String CLOSE_MENU_TEXT = "Close \"";
    private static final String CLOSE_ALL_EXCEPT_MENU_TEXT = "Close all except \"";
    private static final String CLOSE_ALL_MENU_TEXT = "Close all";
    private static final String ClOSE_GROUP_MENU_PREFIX_TEXT = " ";
    private static final String ClOSE_GROUP_MENU_POST_TEXT = " tabs";
    private static final String FAVORITE_TAB_TEXT = "Favorite Tab";
    private static final TabCloseIconMouseListener mouseListener = new TabCloseIconMouseListener();
    private Color colorObj = null;
    private final Icon icon;
    private String group = null;
    private Set groupSet = null;
    private int width = 0;
    private int height = 0;
    private int dx = 0;
    private int dy = 0;
    private JTabbedPane tabbedPane = null;
    private transient Rectangle position = null;
    private boolean favoriteTabFlag = false;
    private static boolean showFavTabMenuItemFlag = false;

    public TabCloseIcon() {
        this(null);
    }

    public TabCloseIcon(Icon icon) {
        this.icon = icon;
        if (icon != null) {
            this.height = icon.getIconHeight();
            this.width = icon.getIconWidth();
        }
    }

    public void actionPerformed(ActionEvent evtObj) {
        block13: {
            try {
                Object sourceObj = evtObj.getSource();
                if (!(sourceObj instanceof JMenuItem) || this.tabbedPane == null) {
                    return;
                }
                String sourceText = ((JMenuItem)sourceObj).getText();
                if (sourceText.startsWith(CLOSE_ALL_EXCEPT_MENU_TEXT)) {
                    String tabNameStr = sourceText.substring(CLOSE_ALL_EXCEPT_MENU_TEXT.length(), sourceText.length() - 1);
                    int tabCount = this.tabbedPane.getTabCount();
                    for (int idx = tabCount - 1; idx >= 0; --idx) {
                        Icon iconObj = this.tabbedPane.getIconAt(idx);
                        if (!(iconObj instanceof TabCloseIcon) || ((TabCloseIcon)iconObj).isFavoriteTab() || tabNameStr.equals(this.tabbedPane.getTitleAt(idx))) continue;
                        this.closeTab(idx);
                    }
                    break block13;
                }
                if (sourceText.startsWith(CLOSE_ALL_MENU_TEXT)) {
                    if (sourceText.equals(CLOSE_ALL_MENU_TEXT)) {
                        int tabCount = this.tabbedPane.getTabCount();
                        for (int idx = tabCount - 1; idx >= 0; --idx) {
                            Icon iconObj = this.tabbedPane.getIconAt(idx);
                            if (!(iconObj instanceof TabCloseIcon) || ((TabCloseIcon)iconObj).isFavoriteTab()) continue;
                            this.closeTab(idx);
                        }
                    } else {
                        String groupStr = sourceText.substring(CLOSE_ALL_MENU_TEXT.length() + ClOSE_GROUP_MENU_PREFIX_TEXT.length(), sourceText.length() - ClOSE_GROUP_MENU_POST_TEXT.length());
                        int tabCount = this.tabbedPane.getTabCount();
                        for (int idx = tabCount - 1; idx >= 0; --idx) {
                            Icon iconObj = this.tabbedPane.getIconAt(idx);
                            if (!(iconObj instanceof TabCloseIcon) || ((TabCloseIcon)iconObj).isFavoriteTab() || !groupStr.equals(((TabCloseIcon)iconObj).group)) continue;
                            this.closeTab(idx);
                        }
                    }
                    break block13;
                }
                if (sourceText.startsWith(CLOSE_MENU_TEXT)) {
                    int tabCount = this.tabbedPane.getTabCount();
                    for (int idx = tabCount - 1; idx >= 0; --idx) {
                        if (!(this.tabbedPane.getIconAt(idx) instanceof TabCloseIcon) || !this.tabbedPane.getTitleAt(idx).equals(sourceText.substring(CLOSE_MENU_TEXT.length(), sourceText.length() - 1))) continue;
                        this.closeTab(idx);
                        break block13;
                    }
                    break block13;
                }
                if (sourceText.equals(FAVORITE_TAB_TEXT)) {
                    this.setFavoriteTabFlag(((JMenuItem)sourceObj).isSelected());
                }
            }
            catch (Exception ex) {
                System.err.println("Error processing tab-close menu item:  " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color previousColor = g.getColor();
        if (this.colorObj != null) {
            g.setColor(this.colorObj);
        }
        if (this.icon != null) {
            this.icon.paintIcon(c, g, x, y);
        } else {
            this.paintDefaultIcon(c, g, x, y);
        }
        g.setColor(previousColor);
        this.position = new Rectangle(x, y, this.getIconWidth(), this.getIconHeight());
        if (this.tabbedPane == null && c instanceof JTabbedPane) {
            this.tabbedPane = (JTabbedPane)c;
            try {
                FocusUtils.setComponentFocusDisabled(this.tabbedPane);
            }
            catch (Exception ex) {
                // empty catch block
            }
            mouseListener.checkAddListenerToComp(this.tabbedPane);
        }
    }

    public Color getColor() {
        return this.colorObj;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void setColor(Color colorObj) {
        this.colorObj = colorObj;
    }

    public TabCloseIcon setGroup(String group, Set groupSet) {
        this.group = group;
        this.groupSet = groupSet;
        return this;
    }

    public void setFavoriteTabFlag(boolean flgVal) {
        this.favoriteTabFlag = flgVal;
    }

    public boolean isFavoriteTab() {
        return this.favoriteTabFlag;
    }

    public static void setFavoriteTabFlagForTab(JTabbedPane tPaneObj, Component compObj, boolean flgVal) {
        Icon iconObj;
        int idx = tPaneObj.indexOfComponent(compObj);
        if (idx >= 0 && (iconObj = tPaneObj.getIconAt(idx)) instanceof TabCloseIcon) {
            ((TabCloseIcon)iconObj).setFavoriteTabFlag(flgVal);
        }
    }

    public static boolean getFavoriteTabFlagForTab(JTabbedPane tPaneObj, Component compObj) {
        Icon iconObj;
        int idx = tPaneObj.indexOfComponent(compObj);
        if (idx >= 0 && (iconObj = tPaneObj.getIconAt(idx)) instanceof TabCloseIcon) {
            return ((TabCloseIcon)iconObj).isFavoriteTab();
        }
        return false;
    }

    public static void setShowFavTabMenuItemFlag(boolean flgVal) {
        showFavTabMenuItemFlag = flgVal;
    }

    public static boolean getShowFavTabMenuItemFlag() {
        return showFavTabMenuItemFlag;
    }

    protected void closeTab(int idx) {
        if (this.tabbedPane == null) {
            return;
        }
        try {
            JPanel tempCompObj;
            if (idx >= this.tabbedPane.getTabCount() - 1) {
                tempCompObj = new JPanel();
                this.tabbedPane.addTab("", tempCompObj);
            } else {
                tempCompObj = null;
            }
            Component tabComp = this.tabbedPane.getComponentAt(idx);
            if (tabComp instanceof CloseTab) {
                ((CloseTab)((Object)tabComp)).closeTab();
            } else if (this.tabbedPane.getIconAt(idx) instanceof TabCloseIcon) {
                this.tabbedPane.removeTabAt(idx);
            }
            if (tempCompObj != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            TabCloseIcon.this.tabbedPane.remove(tempCompObj);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean contains(MouseEvent e) {
        return this.position != null && this.position.contains(e.getX(), e.getY());
    }

    protected void paintDefaultIcon(Component c, Graphics g, int x, int y) {
        if (this.height == 0) {
            Font f = c.getFont();
            if (f == null) {
                f = new Font("Dialog", 1, 12);
            }
            this.height = this.width = g.getFontMetrics(f).charWidth('X');
            this.dy = this.dx = (this.width + 2) / 4;
        }
        if (!Color.black.equals(g.getColor())) {
            g.fillOval(x - this.dx, y - this.dy, this.width + this.dx * 2, this.height + this.dy * 2);
            g.setColor(Color.black);
        } else {
            g.drawOval(x - this.dx, y - this.dy, this.width + this.dx * 2, this.height + this.dy * 2);
        }
        g.drawLine(x, y, x + this.width, y + this.height);
        g.drawLine(x, y + this.height, x + this.width, y);
    }

    protected static class TabCloseIconMouseListener
    extends MouseAdapter {
        private JTabbedPane curTabbedPane = null;
        private int curTabIdx = -1;
        private TabCloseIcon curTabCloseIcon = null;
        private final HashSet hostComponentsSet = new HashSet();

        protected TabCloseIconMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (!this.getTabInfo(e)) {
                return;
            }
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.getTabInfo(e)) {
                return;
            }
            this.maybeShowPopup(e);
            if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && this.curTabCloseIcon.contains(e)) {
                this.curTabCloseIcon.closeTab(this.curTabIdx);
                e.consume();
            }
        }

        public void checkAddListenerToComp(Component compObj) {
            if (!this.hostComponentsSet.contains(compObj)) {
                this.hostComponentsSet.add(compObj);
                compObj.addMouseListener(this);
            }
        }

        protected void addMenuItem(JPopupMenu pop, JMenuItem mi) {
            mi.addActionListener(this.curTabCloseIcon);
            pop.add(mi);
        }

        protected void addMenuItems(JPopupMenu pop, String curTitle) {
            this.addMenuItem(pop, new JMenuItem(TabCloseIcon.CLOSE_MENU_TEXT + curTitle));
            this.addMenuItem(pop, new JMenuItem(TabCloseIcon.CLOSE_ALL_EXCEPT_MENU_TEXT + curTitle));
            this.addMenuItem(pop, new JMenuItem(TabCloseIcon.CLOSE_ALL_MENU_TEXT));
            if (this.curTabCloseIcon.groupSet != null && this.curTabCloseIcon.groupSet.size() > 0) {
                pop.addSeparator();
                Iterator it = this.curTabCloseIcon.groupSet.iterator();
                while (it.hasNext()) {
                    this.addMenuItem(pop, new JMenuItem("Close all " + it.next() + TabCloseIcon.ClOSE_GROUP_MENU_POST_TEXT));
                }
            }
            if (showFavTabMenuItemFlag) {
                pop.addSeparator();
                this.addMenuItem(pop, new JCheckBoxMenuItem(TabCloseIcon.FAVORITE_TAB_TEXT, this.curTabCloseIcon.isFavoriteTab()));
            }
        }

        protected boolean getTabInfo(MouseEvent e) {
            this.curTabbedPane = null;
            this.curTabIdx = -1;
            this.curTabCloseIcon = null;
            Object source = e.getSource();
            if (!(source instanceof JTabbedPane)) {
                return false;
            }
            this.curTabbedPane = (JTabbedPane)source;
            this.curTabIdx = this.curTabbedPane.getSelectedIndex();
            if (this.curTabIdx < 0) {
                return false;
            }
            Icon curIcon = this.curTabbedPane.getIconAt(this.curTabIdx);
            if (!(curIcon instanceof TabCloseIcon)) {
                return false;
            }
            this.curTabCloseIcon = (TabCloseIcon)curIcon;
            return true;
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (e.isConsumed() || !e.isPopupTrigger()) {
                return;
            }
            e.consume();
            String curTitle = this.curTabbedPane.getTitleAt(this.curTabIdx) + "\"";
            JPopupMenu pop = new JPopupMenu();
            this.addMenuItems(pop, curTitle);
            pop.show(this.curTabbedPane, e.getX(), e.getY());
        }
    }

    public static interface CloseTab {
        public void closeTab();
    }
}

